/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.model.tape;

import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.tape.KeypunchBlockEntity;
import malte0811.controlengineering.client.model.CEBakedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.BakedQuadVertexBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class KeypunchSwitchModel
implements CEBakedModel {
    public static final ResourceLocation TEXTURE_LOC = new ResourceLocation("controlengineering", "block/keypunch");
    private static final ModelProperty<Boolean> LOOPBACK = new ModelProperty();
    private final Supplier<TextureAtlasSprite> texture = Suppliers.memoize(() -> (TextureAtlasSprite)ForgeModelBakery.defaultTextureGetter().apply(new Material(InventoryMenu.f_39692_, TEXTURE_LOC)));
    private final Supplier<BakedQuad> loopbackQuad;
    private final Supplier<BakedQuad> remoteQuad;

    public KeypunchSwitchModel(ItemTransforms transforms, ModelState modelTransform) {
        PoseStack transform = new PoseStack();
        modelTransform.m_6189_().blockCenterToCorner().push(transform);
        this.loopbackQuad = Suppliers.memoize(() -> this.makeQuad(6.5, transform));
        this.remoteQuad = Suppliers.memoize(() -> this.makeQuad(8.5, transform));
    }

    private BakedQuad makeQuad(double xMin, PoseStack transform) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double epsilon = 5.0E-4;
        new QuadBuilder(new Vec3(xMin / 16.0, 0.8125, 1.0005), new Vec3((xMin + 1.0) / 16.0, 0.8125, 1.0005), new Vec3((xMin + 1.0) / 16.0, 1.0, 1.0005), new Vec3(xMin / 16.0, 1.0, 1.0005)).setSprite(this.texture.get()).setUCoords(0.6875f, 0.6875f, 0.734375f, 0.734375f).setVCoords(0.5f, 0.46875f, 0.46875f, 0.5f).writeTo(new BakedQuadVertexBuilder(this.texture.get(), transform, quads).dontInterpolateUV());
        return (BakedQuad)quads.get(0);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.texture.get();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Boolean loopbackNullable = (Boolean)extraData.getData(LOOPBACK);
        if (loopbackNullable != null && loopbackNullable.booleanValue()) {
            return List.of(this.loopbackQuad.get());
        }
        return List.of(this.remoteQuad.get());
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof KeypunchBlockEntity) {
            KeypunchBlockEntity keypunch = (KeypunchBlockEntity)blockEntity;
            return new SinglePropertyModelData((Object)keypunch.isLoopback(), LOOPBACK);
        }
        return tileData;
    }
}

