/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.model.tape;

import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.tape.SequencerBlockEntity;
import malte0811.controlengineering.client.model.CEBakedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.BakedQuadVertexBuilder;
import malte0811.controlengineering.util.Bool2ObjectMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class SequencerSwitchModel
implements CEBakedModel {
    public static final ResourceLocation TEXTURE_LOC = new ResourceLocation("controlengineering", "block/sequencer");
    private static final ModelProperty<Data> DATA = new ModelProperty();
    private final Supplier<TextureAtlasSprite> texture = Suppliers.memoize(() -> (TextureAtlasSprite)ForgeModelBakery.defaultTextureGetter().apply(new Material(InventoryMenu.f_39692_, TEXTURE_LOC)));
    private final Supplier<Bool2ObjectMap<BakedQuad>> compactSwitch;
    private final Supplier<Bool2ObjectMap<BakedQuad>> autoresetSwitch;
    private final Supplier<BakedQuad> clockQuad;

    public SequencerSwitchModel(ItemTransforms transforms, ModelState modelTransform) {
        PoseStack transform = new PoseStack();
        modelTransform.m_6189_().blockCenterToCorner().push(transform);
        this.compactSwitch = this.makeSwitchQuads(4.5, transform);
        this.autoresetSwitch = this.makeSwitchQuads(10.5, transform);
        this.clockQuad = Suppliers.memoize(() -> {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            new QuadBuilder(new Vec3(1.0, 0.625, 0.375), new Vec3(1.0, 0.625, 0.625), new Vec3(1.0, 0.375, 0.625), new Vec3(1.0, 0.375, 0.375)).setSprite(this.texture.get()).setUCoords(0.375f, 0.4375f, 0.4375f, 0.375f).setVCoords(0.0625f, 0.0625f, 0.1875f, 0.1875f).writeTo(new BakedQuadVertexBuilder(this.texture.get(), transform, quads).dontInterpolateUV());
            return (BakedQuad)quads.get(0);
        });
    }

    private Supplier<Bool2ObjectMap<BakedQuad>> makeSwitchQuads(double xMin, PoseStack transform) {
        return Suppliers.memoize(() -> {
            Bool2ObjectMap<BakedQuad> result = new Bool2ObjectMap<BakedQuad>();
            result.put(false, this.makeSwitchQuad(xMin, 16.0f, transform));
            result.put(true, this.makeSwitchQuad(xMin, 17.0f, transform));
            return result;
        });
    }

    private BakedQuad makeSwitchQuad(double xMin, float uMin, PoseStack transform) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double epsilon = 5.0E-4;
        new QuadBuilder(new Vec3(xMin / 16.0, 0.21875, 1.0005), new Vec3((xMin + 1.0) / 16.0, 0.21875, 1.0005), new Vec3((xMin + 1.0) / 16.0, 0.34375, 1.0005), new Vec3(xMin / 16.0, 0.34375, 1.0005)).setSprite(this.texture.get()).setUCoords(uMin / 64.0f, (uMin + 1.0f) / 64.0f, (uMin + 1.0f) / 64.0f, uMin / 64.0f).setVCoords(0.0625f, 0.0625f, 0.125f, 0.125f).writeTo(new BakedQuadVertexBuilder(this.texture.get(), transform, quads).dontInterpolateUV());
        return (BakedQuad)quads.get(0);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.texture.get();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Data data = (Data)extraData.getData(DATA);
        if (data == null) {
            return List.of();
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(3);
        result.add(this.compactSwitch.get().get(data.compact));
        result.add(this.autoresetSwitch.get().get(data.autoReset));
        if (data.hasClock) {
            result.add(this.clockQuad.get());
        }
        return result;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SequencerBlockEntity) {
            SequencerBlockEntity sequencer = (SequencerBlockEntity)blockEntity;
            return new SinglePropertyModelData((Object)new Data(sequencer.isCompact(), sequencer.isAutoreset(), sequencer.hasClock()), DATA);
        }
        return CEBakedModel.super.getModelData(world, pos, state, tileData);
    }

    private record Data(boolean compact, boolean autoReset, boolean hasClock) {
    }
}

