/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.panel;

import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import malte0811.controlengineering.blockentity.panels.CNCJob;
import malte0811.controlengineering.blockentity.panels.PanelCNCBlockEntity;
import malte0811.controlengineering.blocks.panels.PanelCNCBlock;
import malte0811.controlengineering.client.render.tape.TapeDriveRender;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.utils.BERUtils;
import malte0811.controlengineering.client.render.utils.ModelRenderUtils;
import malte0811.controlengineering.client.render.utils.PiecewiseAffinePath;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderers;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PanelCNCRenderer
implements BlockEntityRenderer<PanelCNCBlockEntity> {
    private static final ResettableLazy<TextureAtlasSprite> MODEL_TEXTURE = new ResettableLazy(() -> {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        return atlas.m_118316_(new ResourceLocation("controlengineering", "block/panel_cnc"));
    });
    private static final LoadingCache<List<PlacedComponent>, MixedModel> MODEL_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(CacheLoader.from(comps -> ComponentRenderers.renderAll(comps, new PoseStack(), new RenderType[0])));
    private static final TapeDriveRender TAPE_DRIVE = new TapeDriveRender(2.0, 1.0, new Vec2d(5.0, 8.0), new Vec2d(7.0, 5.0), new Vec2d(11.0, 8.0), new Vec2d(9.0, 5.0));
    private static final double HEAD_SIZE = 0.5;
    private static final double HEAD_TRAVERSAL_HEIGHT = 3.0;
    private static final double HEAD_WORK_HEIGHT = -1.0;
    private static final Vec3 HEAD_IDLE = new Vec3(7.75, 5.0, 7.75);
    private static final Quaternion TAPE_ROTATION = new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true);

    public PanelCNCRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@Nonnull PanelCNCBlockEntity cnc, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource buffers, int light, int overlay) {
        transform.m_85836_();
        BERUtils.rotateAroundCenter(-PanelCNCBlock.getDirection(cnc).m_122435_() + 180.0f, transform);
        transform.m_85841_(0.0625f, 0.0625f, 0.0625f);
        double tick = (float)cnc.getCurrentTicksInJob() + (cnc.getState() == PanelCNCBlockEntity.State.RUNNING ? partialTicks : 0.0f);
        transform.m_85836_();
        transform.m_85837_(0.0, 16.0, 14.0);
        transform.m_85845_(TAPE_ROTATION);
        this.renderTape(cnc, buffers, transform, light, overlay, tick);
        transform.m_85849_();
        transform.m_85837_(0.0, 16.0, 0.0);
        transform.m_85836_();
        transform.m_85837_(1.0, 0.0, 1.0);
        transform.m_85841_(0.875f, 0.875f, 0.875f);
        this.renderCurrentPanelState(cnc, buffers, transform, light, overlay);
        this.renderHead(cnc, buffers, transform, light, overlay, tick);
        transform.m_85849_();
        transform.m_85849_();
    }

    private void renderCurrentPanelState(PanelCNCBlockEntity cnc, MultiBufferSource buffers, PoseStack transform, int light, int overlay) {
        VertexConsumer builder = buffers.m_6299_(RenderType.m_110451_());
        if (cnc.getState().hasPanel()) {
            VertexConsumer forTexture = ((TextureAtlasSprite)MODEL_TEXTURE.get()).m_118381_(builder);
            TransformingVertexBuilder finalWrapped = new TransformingVertexBuilder(forTexture, transform, DefaultVertexFormat.f_85811_);
            finalWrapped.setColor(-1).setLight(light).setNormal(0.0f, 1.0f, 0.0f).setOverlay(overlay);
            float minU = 0.265625f;
            float maxU = 0.484375f;
            float minV = 0.96875f;
            float maxV = 0.53125f;
            finalWrapped.vertex(0.0, 0.0, 0.0).uv(0.265625f, 0.96875f).m_5752_();
            finalWrapped.vertex(0.0, 0.0, 16.0).uv(0.265625f, 0.53125f).m_5752_();
            finalWrapped.vertex(16.0, 0.0, 16.0).uv(0.484375f, 0.53125f).m_5752_();
            finalWrapped.vertex(16.0, 0.0, 0.0).uv(0.484375f, 0.96875f).m_5752_();
        }
        ((MixedModel)MODEL_CACHE.getUnchecked(cnc.getCurrentPlacedComponents())).renderTo(buffers, transform, light, overlay);
    }

    private void renderTape(PanelCNCBlockEntity cncBE, MultiBufferSource buffer, PoseStack transform, int light, int overlay, double ticks) {
        long totLength = cncBE.getTapeLength();
        if (totLength > 0L) {
            CNCJob currentJob = cncBE.getCurrentJob();
            Preconditions.checkNotNull((Object)currentJob);
            TAPE_DRIVE.setTotalLength(totLength + 1L);
            TAPE_DRIVE.updateTapeProgress(currentJob.getTapeProgressAtTime(ticks));
            TAPE_DRIVE.render(buffer.m_6299_(RenderType.m_110451_()), transform, light, overlay);
        }
    }

    private void renderHead(PanelCNCBlockEntity cncBE, MultiBufferSource buffer, PoseStack transform, int light, int overlay, double ticks) {
        Vec3 currentPos;
        if (cncBE.getCurrentJob() != null && cncBE.getState().isInProcess()) {
            if (cncBE.headPath == null) {
                cncBE.headPath = new CachedValue<CNCJob, PiecewiseAffinePath>(cncBE::getCurrentJob, PanelCNCRenderer::createPathFor);
            }
            currentPos = cncBE.headPath.get().getPosAt(ticks);
        } else {
            currentPos = HEAD_IDLE;
        }
        transform.m_85836_();
        transform.m_85837_(currentPos.f_82479_, 0.0, currentPos.f_82481_);
        VertexConsumer solidBuffer = buffer.m_6299_(RenderType.m_110451_());
        VertexConsumer forTexture = ((TextureAtlasSprite)MODEL_TEXTURE.get()).m_118381_(solidBuffer);
        TransformingVertexBuilder innerBuilder = new TransformingVertexBuilder(forTexture, transform, DefaultVertexFormat.f_85811_);
        innerBuilder.setOverlay(overlay).setLight(light).setColor(-1);
        this.renderHeadModel(innerBuilder, (float)currentPos.f_82480_);
        transform.m_85849_();
    }

    private void renderHeadModel(TransformingVertexBuilder builder, float yMin) {
        float yMax = 12.0f;
        float headHeight = 1.0f;
        ModelRenderUtils.UVCoord tipMin = new ModelRenderUtils.UVCoord(0.25f, 0.3125f);
        ModelRenderUtils.UVCoord tipMax = new ModelRenderUtils.UVCoord(0.28125f, 0.4375f);
        ModelRenderUtils.renderTube(builder, 0.0, 0.5, yMin, yMin + 1.0f, tipMin, tipMax);
        ModelRenderUtils.UVCoord shaftMin = new ModelRenderUtils.UVCoord(0.28125f, 0.3125f);
        float shaftLength = 12.0f - yMin - 1.0f;
        ModelRenderUtils.UVCoord shaftMax = new ModelRenderUtils.UVCoord((30.0f - shaftLength) / 64.0f, 0.4375f);
        ModelRenderUtils.renderTube(builder, 0.5, 0.5, yMin + 1.0f, 12.0, shaftMin, shaftMax);
    }

    private static PiecewiseAffinePath<Vec3> createPathFor(CNCJob job) {
        double arrival = 0.5;
        double down = 0.5625;
        double done = 0.9375;
        double up = 1.0;
        ArrayList nodes = new ArrayList();
        int lastComponentTime = 0;
        nodes.add(new PiecewiseAffinePath.Node<Vec3>(HEAD_IDLE, lastComponentTime));
        for (int i = 0; i < job.getTotalComponents(); ++i) {
            PlacedComponent nextComponent = (PlacedComponent)job.components().get(i);
            Vec2d min = nextComponent.getPosMin();
            Vec2d max = nextComponent.getPosMax((Level)Minecraft.m_91087_().f_91073_).subtract(new Vec2d(0.5, 0.5));
            int nextComponentTime = job.tickPlacingComponent().getInt(i);
            double arrivalAtComponent = Mth.m_14139_((double)0.5, (double)lastComponentTime, (double)nextComponentTime);
            nodes.add(new PiecewiseAffinePath.Node<Vec3>(new Vec3(min.x(), 3.0, min.y()), arrivalAtComponent));
            double downAtComp = Mth.m_14139_((double)0.5625, (double)lastComponentTime, (double)nextComponentTime);
            double doneAtComp = Mth.m_14139_((double)0.9375, (double)lastComponentTime, (double)nextComponentTime);
            Vec2d[] corners = new Vec2d[]{min, new Vec2d(min.x(), max.y()), max, new Vec2d(max.x(), min.y()), min};
            for (int point = 0; point < corners.length; ++point) {
                double cornerTime = Mth.m_14139_((double)((double)point / (double)(corners.length - 1)), (double)downAtComp, (double)doneAtComp);
                nodes.add(new PiecewiseAffinePath.Node<Vec3>(new Vec3(corners[point].x(), -1.0, corners[point].y()), cornerTime));
            }
            double upAtComp = Mth.m_14139_((double)1.0, (double)lastComponentTime, (double)nextComponentTime);
            nodes.add(new PiecewiseAffinePath.Node<Vec3>(new Vec3(min.x(), 3.0, min.y()), upAtComp));
            lastComponentTime = nextComponentTime;
        }
        nodes.add(new PiecewiseAffinePath.Node<Vec3>(HEAD_IDLE, job.totalTicks()));
        return new PiecewiseAffinePath<Vec3>(nodes, Vec3::m_82490_, Vec3::m_82549_);
    }
}

