/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.tape;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import malte0811.controlengineering.client.render.tape.TapeWheel;
import malte0811.controlengineering.util.math.Vec2d;

public class TapeDriveRender {
    private double totalLength;
    private double lambda;
    private final double emptyRadius;
    private final double fullRadius;
    private final TapeWheel leftWheel;
    private final Vec2d leftCenter;
    private final TapeWheel rightWheel;
    private final Vec2d rightCenter;

    public TapeDriveRender(double fullRadius, double emptyRadius, Vec2d leftCenter, Vec2d leftTarget, Vec2d rightCenter, Vec2d rightTarget) {
        this.fullRadius = fullRadius;
        this.leftCenter = leftCenter;
        this.leftWheel = new TapeWheel(leftTarget.subtract(leftCenter), fullRadius, false);
        this.rightCenter = rightCenter;
        this.rightWheel = new TapeWheel(rightTarget.subtract(rightCenter), fullRadius, true);
        this.emptyRadius = emptyRadius;
        this.updateTapeProgress(0.0);
    }

    public void setTotalLength(double totalLength) {
        this.totalLength = totalLength;
        this.lambda = (this.fullRadius * this.fullRadius - this.emptyRadius * this.emptyRadius) / totalLength;
    }

    public void render(VertexConsumer output, PoseStack stack, int light, int overlay) {
        stack.m_85836_();
        stack.m_85837_(this.leftCenter.x(), 0.0, this.leftCenter.y());
        this.leftWheel.render(output, stack, light, overlay);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(this.rightCenter.x(), 0.0, this.rightCenter.y());
        this.rightWheel.render(output, stack, light, overlay);
        stack.m_85849_();
    }

    public void updateTapeProgress(double lengthOnRight) {
        this.leftWheel.setRadius(this.getRadius(this.totalLength - lengthOnRight) / this.fullRadius);
        this.rightWheel.setRadius(this.getRadius(lengthOnRight) / this.fullRadius);
        this.leftWheel.setRotationRadians(this.getRotationInBetween(0.0, this.totalLength - lengthOnRight));
        this.rightWheel.setRotationRadians(this.getRotationInBetween(lengthOnRight, 0.0));
    }

    private double getRotationInBetween(double lengthA, double lengthB) {
        return 2.0 / this.lambda * (this.getRadius(lengthB) - this.getRadius(lengthA));
    }

    private double getRadius(double length) {
        return Math.sqrt(this.lambda * length + this.emptyRadius * this.emptyRadius);
    }
}

