/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.tape;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import java.util.List;
import java.util.function.BiPredicate;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;

public class TapeWheel {
    private static final int NUM_CORNERS = 6;
    private static final double TAPE_WIDTH = 1.0;
    private static final List<Vec2d> CORNERS_NORMALIZED;
    private static final ResettableLazy<TextureAtlasSprite> TEXTURE;
    private static final List<Pair<Integer, Double>> offsetAndHeight;
    private final Vec2d tapeTarget;
    private final double maxRenderRadius;
    private final BiPredicate<Double, Double> leftBetter;
    private double radius;
    private double rotationRadians;

    public TapeWheel(Vec2d tapeTarget, double maxRenderRadius, boolean isRight) {
        this.tapeTarget = tapeTarget;
        this.maxRenderRadius = maxRenderRadius;
        this.leftBetter = isRight ? (a, b) -> a > b : (a, b) -> a < b;
    }

    public void render(VertexConsumer output, PoseStack stack, int light, int overlay) {
        SpriteCoordinateExpander spriteBuilder = new SpriteCoordinateExpander(output, (TextureAtlasSprite)TEXTURE.get());
        TransformingVertexBuilder finalBuilder = new TransformingVertexBuilder((VertexConsumer)spriteBuilder, stack, DefaultVertexFormat.f_85811_);
        finalBuilder.setColor(16754937);
        finalBuilder.setNormal(0.0f, 1.0f, 0.0f);
        finalBuilder.setOverlay(overlay);
        finalBuilder.setLight(light);
        this.renderTapeRoll(finalBuilder, stack);
        this.renderTapeToTarget(finalBuilder);
    }

    private void renderTapeToTarget(VertexConsumer output) {
        Vec2d vec;
        int bestCorner = 0;
        double bestValue = this.getSlopeFrom(bestCorner);
        for (int newCorner = 1; newCorner < 6; ++newCorner) {
            double newValue = this.getSlopeFrom(newCorner);
            if (!this.leftBetter.test(bestValue, newValue)) continue;
            bestValue = newValue;
            bestCorner = newCorner;
        }
        Vec2d[] positions = new Vec2d[]{this.cornerRotated(bestCorner), this.tapeTarget};
        Vec2d cornerUV = this.cornerRelative(bestCorner);
        for (Pair<Integer, Double> pos : offsetAndHeight) {
            vec = positions[(Integer)pos.getFirst()];
            output.m_5483_(vec.x(), ((Double)pos.getSecond()).doubleValue(), vec.y()).m_7421_(this.toUV(cornerUV.x()), this.toUV(cornerUV.y())).m_5752_();
        }
        for (int i = offsetAndHeight.size() - 1; i >= 0; --i) {
            Pair<Integer, Double> pos;
            pos = offsetAndHeight.get(i);
            vec = positions[(Integer)pos.getFirst()];
            output.m_5483_(vec.x(), ((Double)pos.getSecond()).doubleValue(), vec.y()).m_7421_(this.toUV(cornerUV.x()), this.toUV(cornerUV.y())).m_5752_();
        }
    }

    private double getSlopeFrom(int cornerId) {
        Vec2d corner = this.cornerRotated(cornerId);
        double deltaX = this.tapeTarget.x() - corner.x();
        double deltaY = this.tapeTarget.y() - corner.y();
        return deltaY / deltaX;
    }

    private void renderTapeRoll(VertexConsumer output, PoseStack stack) {
        stack.m_85836_();
        stack.m_85845_(new Quaternion(0.0f, (float)this.rotationRadians, 0.0f, false));
        int i = 1;
        while (i + 2 < 6) {
            for (int vertex : new int[]{0, i, i + 1, i + 2}) {
                Vec2d posNormalized = this.cornerRelative(vertex);
                output.m_5483_(posNormalized.x(), 1.0, posNormalized.y()).m_7421_(this.toUV(posNormalized.x()), this.toUV(posNormalized.y())).m_5752_();
            }
            i += 2;
        }
        ImmutableList offsetAndHeight = ImmutableList.of((Object)Pair.of((Object)0, (Object)0.0), (Object)Pair.of((Object)1, (Object)0.0), (Object)Pair.of((Object)1, (Object)1.0), (Object)Pair.of((Object)0, (Object)1.0));
        for (int i2 = 0; i2 < 6; ++i2) {
            for (Pair quadVertex : offsetAndHeight) {
                Vec2d posNormalized = this.cornerRelative(((Integer)quadVertex.getFirst() + i2) % 6);
                output.m_5483_(posNormalized.x(), ((Double)quadVertex.getSecond()).doubleValue(), posNormalized.y()).m_7421_(this.toUV(posNormalized.x()), this.toUV(posNormalized.y())).m_5752_();
            }
        }
        stack.m_85849_();
    }

    private Vec2d cornerRotated(int vertex) {
        double cos = Math.cos(this.rotationRadians);
        double sin = Math.sin(this.rotationRadians);
        Vec2d baseVertex = this.cornerRelative(vertex);
        return new Vec2d(cos * baseVertex.x() + sin * baseVertex.y(), -sin * baseVertex.x() + cos * baseVertex.y());
    }

    private Vec2d cornerRelative(int vertex) {
        return CORNERS_NORMALIZED.get(vertex).scale(this.radius * this.maxRenderRadius);
    }

    private float toUV(double pmMaxRadiusRelative) {
        return Mth.m_14036_((float)((float)(0.5 * (1.0 + pmMaxRadiusRelative / this.maxRenderRadius))), (float)0.001f, (float)0.999f);
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setRotationRadians(double rotationRadians) {
        this.rotationRadians = rotationRadians;
    }

    static {
        TEXTURE = new ResettableLazy(QuadBuilder::getWhiteTexture);
        offsetAndHeight = ImmutableList.of((Object)Pair.of((Object)0, (Object)0.0), (Object)Pair.of((Object)1, (Object)0.0), (Object)Pair.of((Object)1, (Object)1.0), (Object)Pair.of((Object)0, (Object)1.0));
        IEApi.renderCacheClearers.add(() -> TEXTURE.reset());
        ImmutableList.Builder corners = ImmutableList.builder();
        for (int i = 0; i < 6; ++i) {
            double angle = (double)(-i * 2) * Math.PI / 6.0;
            corners.add((Object)new Vec2d(Math.cos(angle), Math.sin(angle)));
        }
        CORNERS_NORMALIZED = corners.build();
        Preconditions.checkState((boolean)true);
    }
}

