/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.target;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import malte0811.controlengineering.client.render.target.DynamicVertex;
import malte0811.controlengineering.client.render.target.DynamicVertexBuilder;
import malte0811.controlengineering.client.render.utils.BakedQuadVertexBuilder;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;

public class MixedModel
implements MultiBufferSource {
    public static final RenderType SOLID_STATIC = RenderType.m_110451_();
    public static final RenderType SOLID_DYNAMIC = MixedModel.createCopy("solid_ter", false, SOLID_STATIC);
    private final Set<RenderType> staticTypes;
    private final List<BakedQuad> staticQuads = new ArrayList<BakedQuad>();
    private final Map<RenderType, List<DynamicVertex>> dynamicQuads = new Object2ObjectArrayMap();
    private TextureAtlasSprite staticSprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(MissingTextureAtlasSprite.m_118071_());

    public MixedModel(RenderType ... staticTypes) {
        this.staticTypes = new ObjectArraySet((Object[])staticTypes);
    }

    @Nonnull
    public VertexConsumer m_6299_(@Nonnull RenderType type) {
        if (this.staticTypes.contains(type)) {
            return new BakedQuadVertexBuilder(this.staticSprite, new PoseStack(), this.staticQuads);
        }
        return new DynamicVertexBuilder(this.dynamicQuads.computeIfAbsent(type, $ -> new ArrayList()));
    }

    public void setSpriteForStaticTargets(TextureAtlasSprite sprite) {
        this.staticSprite = sprite;
    }

    public List<BakedQuad> getStaticQuads() {
        return this.staticQuads;
    }

    public void renderTo(MultiBufferSource out, PoseStack transform, int combinedLight, int combinedOverlay) {
        for (Map.Entry<RenderType, List<DynamicVertex>> vertices : this.dynamicQuads.entrySet()) {
            TransformingVertexBuilder buffer = new TransformingVertexBuilder(out.m_6299_(vertices.getKey()), transform, DefaultVertexFormat.f_85811_);
            for (DynamicVertex v : vertices.getValue()) {
                v.accept(buffer, combinedLight, combinedOverlay);
            }
        }
    }

    private static RenderType createCopy(String name, boolean needsSorting, RenderType original) {
        return new RenderType(name, original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), needsSorting, () -> ((RenderType)original).m_110185_(), () -> ((RenderType)original).m_110188_()){};
    }
}

