/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.target;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.BitUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="controlengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class QuadBuilder {
    public static final ResourceLocation WHITE_WITH_BORDER = new ResourceLocation("controlengineering", "white_with_border");
    private final Vertex[] vertices;
    @Nullable
    private TextureAtlasSprite sprite;
    @Nullable
    private Vec3 normal;
    private OptionalInt blockLightOverride = OptionalInt.empty();
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;

    public QuadBuilder(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        this.vertices = new Vertex[]{new Vertex(v1, 0.0f, 0.0f), new Vertex(v2, 0.0f, 1.0f), new Vertex(v3, 1.0f, 1.0f), new Vertex(v4, 1.0f, 0.0f)};
    }

    public QuadBuilder setSprite(@Nonnull TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public QuadBuilder setNormal(@Nullable Vec3 normal) {
        this.normal = normal;
        return this;
    }

    public QuadBuilder setUCoords(float u1, float u2, float u3, float u4) {
        this.vertices[0].spriteU = u1;
        this.vertices[1].spriteU = u2;
        this.vertices[2].spriteU = u3;
        this.vertices[3].spriteU = u4;
        return this;
    }

    public QuadBuilder setVCoords(float v1, float v2, float v3, float v4) {
        this.vertices[0].spriteV = v1;
        this.vertices[1].spriteV = v2;
        this.vertices[2].spriteV = v3;
        this.vertices[3].spriteV = v4;
        return this;
    }

    public QuadBuilder setRGBA(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public QuadBuilder setRGB(int packed) {
        return this.setRGBA(QuadBuilder.extract8BitFloat(packed, 16), QuadBuilder.extract8BitFloat(packed, 8), QuadBuilder.extract8BitFloat(packed, 0), 1.0f);
    }

    private static float extract8BitFloat(int value, int offset) {
        return (float)BitUtils.getBits(value, offset, 8) / 255.0f;
    }

    public QuadBuilder setBlockLightOverride(int blockLightOverride) {
        this.blockLightOverride = OptionalInt.of(blockLightOverride);
        return this;
    }

    public void writeTo(VertexConsumer target) {
        TextureAtlasSprite sprite = this.sprite == null ? QuadBuilder.getWhiteTexture() : this.sprite;
        Vec3 normalD = this.normal == null ? this.automaticNormal() : this.normal;
        Vector3f normal = new Vector3f(normalD);
        for (Vertex v : this.vertices) {
            target.m_5954_((float)v.position.f_82479_, (float)v.position.f_82480_, (float)v.position.f_82481_, this.red, this.green, this.blue, this.alpha, sprite.m_118367_((double)(16.0f * v.spriteU)), sprite.m_118393_((double)(16.0f * v.spriteV)), OverlayTexture.f_118083_, this.blockLightOverride.orElse(0), normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
    }

    private Vec3 automaticNormal() {
        Vec3 first = this.vertices[0].position;
        Vec3 second = this.vertices[1].position;
        Vec3 third = this.vertices[2].position;
        return first.m_82546_(second).m_82537_(first.m_82546_(third)).m_82541_();
    }

    public static TextureAtlasSprite getWhiteTexture() {
        return Objects.requireNonNull(Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(WHITE_WITH_BORDER));
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre ev) {
        if (ev.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            ev.addSprite(WHITE_WITH_BORDER);
        }
    }

    private static class Vertex {
        private final Vec3 position;
        private float spriteU;
        private float spriteV;

        private Vertex(Vec3 position, float spriteU, float spriteV) {
            this.position = position;
            this.spriteU = spriteU;
            this.spriteV = spriteV;
        }
    }
}

