/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.target;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.Map;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.util.DirectionUtils;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    public static final Map<Direction, RenderType> ALL_DYNAMIC = (Map)Util.m_137469_(new EnumMap(Direction.class), types -> {
        for (Direction side : DirectionUtils.VALUES) {
            types.put(side, MixedModel.SOLID_DYNAMIC);
        }
    });
    public static final Map<Direction, RenderType> ALL_STATIC = (Map)Util.m_137469_(new EnumMap(Direction.class), types -> {
        for (Direction side : DirectionUtils.VALUES) {
            types.put(side, MixedModel.SOLID_STATIC);
        }
    });

    public static void renderColoredBox(MixedModel output, PoseStack transform, Vec3 min, Vec3 max, Map<Direction, Integer> sideColors, Map<Direction, Integer> lightOverrides, Map<Direction, RenderType> targets) {
        RenderUtils.renderColoredBox(output, transform, min, max, sideColors, lightOverrides, targets, false);
    }

    public static void renderColoredBox(MixedModel output, PoseStack transform, Vec3 min, Vec3 max, Map<Direction, Integer> sideColors, Map<Direction, Integer> lightOverrides, Map<Direction, RenderType> targets, boolean invert) {
        output.setSpriteForStaticTargets(QuadBuilder.getWhiteTexture());
        for (Map.Entry<Direction, Integer> entry : sideColors.entrySet()) {
            Direction side = entry.getKey();
            Direction.Axis normal = side.m_122434_();
            Direction.Axis orthA = Direction.Axis.values()[(normal.ordinal() + 1) % 3];
            Direction.Axis orthB = Direction.Axis.values()[(normal.ordinal() + 2) % 3];
            boolean positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            Vec3 posA = positive ? max : min;
            Vec3 posB = positive ? min : max;
            TransformingVertexBuilder out = new TransformingVertexBuilder(output.m_6299_(targets.get(side)), transform, DefaultVertexFormat.f_85811_);
            Vec3[] vertices = new Vec3[]{posA, RenderUtils.withValueFrom(posA, positive ? orthA : orthB, posB), RenderUtils.withValueFrom(posB, normal, posA), RenderUtils.withValueFrom(posA, positive ? orthB : orthA, posB)};
            new QuadBuilder(vertices[invert ? 3 : 0], vertices[invert ? 2 : 1], vertices[invert ? 1 : 2], vertices[invert ? 0 : 3]).setBlockLightOverride(lightOverrides.getOrDefault(side, 0)).setRGB(entry.getValue()).setNormal(Vec3.m_82528_((Vec3i)side.m_122436_())).writeTo(out);
        }
    }

    private static Vec3 withValueFrom(Vec3 main, Direction.Axis axis, Vec3 from) {
        return RenderUtils.with(main, axis, axis.m_6150_(from.f_82479_, from.f_82480_, from.f_82481_));
    }

    private static Vec3 with(Vec3 in, Direction.Axis axis, double value) {
        return new Vec3(axis == Direction.Axis.X ? value : in.f_82479_, axis == Direction.Axis.Y ? value : in.f_82480_, axis == Direction.Axis.Z ? value : in.f_82481_);
    }

    public static Map<Direction, Integer> makeColorsExcept(int color, Direction ... excluded) {
        EnumMap<Direction, Integer> map = new EnumMap<Direction, Integer>(Direction.class);
        for (Direction side : DirectionUtils.VALUES) {
            map.put(side, color);
        }
        for (Direction excludedSide : excluded) {
            map.remove(excludedSide);
        }
        return map;
    }
}

