/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.List;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class BakedQuadVertexBuilder
extends TransformingVertexBuilder {
    private final TextureAtlasSprite sprite;
    private final List<BakedQuad> quads;
    private BakedQuadBuilder builder = null;
    private int nextVertex = 0;
    private boolean interpolateUV = true;

    public BakedQuadVertexBuilder(TextureAtlasSprite sprite, PoseStack transform, List<BakedQuad> quads) {
        super(null, transform, DefaultVertexFormat.f_85811_);
        this.sprite = sprite;
        this.quads = quads;
    }

    public BakedQuadVertexBuilder dontInterpolateUV() {
        this.interpolateUV = false;
        return this;
    }

    @Override
    public void m_5752_() {
        if (this.builder == null) {
            this.builder = new BakedQuadBuilder(this.sprite);
        }
        Vec3 pos = (Vec3)this.pos.read();
        Vector4f transformedPos = new Vector4f((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, 1.0f);
        transformedPos.m_123607_(this.transform.m_85850_().m_85861_());
        transformedPos.m_123621_();
        Vec2 uv = (Vec2)this.uv.read();
        Vector3f normal = (Vector3f)this.normal.read();
        normal.m_122249_(this.transform.m_85850_().m_85864_());
        BakedQuadVertexBuilder.putVertex((IVertexConsumer)this.builder, normal, transformedPos, (Vector4f)this.color.read(), this.interpolateUV ? this.sprite.m_118367_((double)uv.f_82470_) : uv.f_82470_, this.interpolateUV ? this.sprite.m_118393_((double)uv.f_82471_) : uv.f_82471_);
        this.lightmap.clear();
        this.overlay.clear();
        ++this.nextVertex;
        if (this.nextVertex == 4) {
            this.nextVertex = 0;
            this.builder.setQuadOrientation(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
            this.quads.add(this.builder.build());
            this.builder = null;
        }
    }

    private static void putVertex(IVertexConsumer consumer, Vector3f normal, Vector4f pos, Vector4f color, float u, float v) {
        VertexFormat format = consumer.getVertexFormat();
        block10: for (int e = 0; e < format.m_86023_().size(); ++e) {
            VertexFormatElement element = (VertexFormatElement)format.m_86023_().get(e);
            switch (element.m_86048_()) {
                case POSITION: {
                    consumer.put(e, new float[]{pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), 1.0f});
                    continue block10;
                }
                case COLOR: {
                    consumer.put(e, new float[]{color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()});
                    continue block10;
                }
                case NORMAL: {
                    consumer.put(e, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_(), 0.0f});
                    continue block10;
                }
                case UV: {
                    switch (element.m_86049_()) {
                        case 0: {
                            consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                            continue block10;
                        }
                        case 2: {
                            consumer.put(e, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                            continue block10;
                        }
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

