/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.utils;

import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import net.minecraft.world.phys.Vec3;

public class ModelRenderUtils {
    private static final int NUM_TUBE_FACES = 4;

    public static void renderTube(TransformingVertexBuilder out, double diameterLow, double diameterHigh, double yMin, double yMax, UVCoord minUV, UVCoord maxUV) {
        double lowerOffset = (diameterHigh - diameterLow) / 2.0;
        float deltaV = (maxUV.v - minUV.v) / 4.0f;
        for (int leftVertex = 0; leftVertex < 4; ++leftVertex) {
            Vec3 normal = ModelRenderUtils.tubeNormal(leftVertex);
            out.setNormal(normal);
            int rightVertex = leftVertex + 1;
            float leftV = deltaV * (float)leftVertex + minUV.v;
            float rightV = deltaV * (float)rightVertex + minUV.v;
            ((TransformingVertexBuilder)out.pos(ModelRenderUtils.tubeVertex(rightVertex, diameterLow, lowerOffset, yMin))).uv(minUV.u, rightV).m_5752_();
            ((TransformingVertexBuilder)out.pos(ModelRenderUtils.tubeVertex(rightVertex, diameterHigh, 0.0, yMax))).uv(maxUV.u, rightV).m_5752_();
            ((TransformingVertexBuilder)out.pos(ModelRenderUtils.tubeVertex(leftVertex, diameterHigh, 0.0, yMax))).uv(maxUV.u, leftV).m_5752_();
            ((TransformingVertexBuilder)out.pos(ModelRenderUtils.tubeVertex(leftVertex, diameterLow, lowerOffset, yMin))).uv(minUV.u, leftV).m_5752_();
        }
    }

    private static Vec3 tubeNormal(int vertex) {
        return new Vec3(0.0, 1.0, 0.0);
    }

    private static Vec3 tubeVertex(int vertex, double diameter, double offset, double y) {
        switch (vertex % 4) {
            case 0: {
                return new Vec3(offset, y, offset);
            }
            case 1: {
                return new Vec3(offset, y, diameter + offset);
            }
            case 2: {
                return new Vec3(diameter + offset, y, diameter + offset);
            }
            case 3: {
                return new Vec3(diameter + offset, y, offset);
            }
        }
        throw new IllegalStateException();
    }

    public record UVCoord(float u, float v) {
    }
}

