/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.utils;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.BinaryOperator;

public record PiecewiseAffinePath<Vec>(List<Node<Vec>> nodes, ScalarMultiplier<Vec> multiplier, BinaryOperator<Vec> adder) {
    public PiecewiseAffinePath {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
    }

    public Vec getPosAt(double time) {
        Node<Vec> first = this.nodes.get(0);
        if (time < first.time) {
            return first.point;
        }
        for (int nextId = 1; nextId < this.nodes.size(); ++nextId) {
            Node<Vec> nextNode = this.nodes.get(nextId);
            if (!(time < nextNode.time)) continue;
            Node<Vec> lastNode = this.nodes.get(nextId - 1);
            double lambda = (time - lastNode.time) / (nextNode.time - lastNode.time);
            return (Vec)this.adder.apply(this.multiplier.scale(lastNode.point, 1.0 - lambda), this.multiplier.scale(nextNode.point, lambda));
        }
        return this.nodes.get((int)(this.nodes.size() - 1)).point;
    }

    @FunctionalInterface
    public static interface ScalarMultiplier<Vec> {
        public Vec scale(Vec var1, double var2);
    }

    public record Node<Vec>(Vec point, double time) {
    }
}

