/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.render.utils;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.client.render.utils.DelegatingVertexBuilder;
import malte0811.controlengineering.util.BitUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TransformingVertexBuilder
extends DelegatingVertexBuilder<TransformingVertexBuilder> {
    protected final PoseStack transform;
    protected final List<ObjectWithGlobal<?>> allObjects = new ArrayList();
    protected final ObjectWithGlobal<Vec2> uv = new ObjectWithGlobal();
    protected final ObjectWithGlobal<Vec3> pos = new ObjectWithGlobal();
    protected final ObjectWithGlobal<Vec2i> overlay = new ObjectWithGlobal();
    protected final ObjectWithGlobal<Vec2i> lightmap = new ObjectWithGlobal();
    protected final ObjectWithGlobal<Vector3f> normal = new ObjectWithGlobal();
    protected final ObjectWithGlobal<Vector4f> color = new ObjectWithGlobal();
    protected final VertexFormat format;

    public TransformingVertexBuilder(VertexConsumer base, PoseStack transform, VertexFormat format) {
        super(base);
        this.transform = transform;
        this.format = format;
    }

    public TransformingVertexBuilder(VertexConsumer base, VertexFormat format) {
        this(base, new PoseStack(), format);
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type, PoseStack transform) {
        this(buffer.m_6299_(type), transform, type.m_110508_());
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder vertex(double x, double y, double z) {
        this.pos.putData(new Vec3(x, y, z));
        return this;
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder color(int red, int green, int blue, int alpha) {
        this.color.putData(new Vector4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f));
        return this;
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder uv(float u, float v) {
        this.uv.putData(new Vec2(u, v));
        return this;
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder overlayCoords(int u, int v) {
        this.overlay.putData(new Vec2i(u, v));
        return this;
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder uv2(int u, int v) {
        this.lightmap.putData(new Vec2i(u, v));
        return this;
    }

    @Override
    @Nonnull
    public TransformingVertexBuilder normal(float x, float y, float z) {
        this.normal.putData(new Vector3f(x, y, z));
        return this;
    }

    @Override
    public void m_5752_() {
        for (VertexFormatElement element : this.format.m_86023_()) {
            if (element == DefaultVertexFormat.f_85804_) {
                this.pos.ifPresent(pos -> this.delegate.m_85982_(this.transform.m_85850_().m_85861_(), (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_));
                continue;
            }
            if (element == DefaultVertexFormat.f_85805_) {
                this.color.ifPresent(c -> this.delegate.m_85950_(c.m_123601_(), c.m_123615_(), c.m_123616_(), c.m_123617_()));
                continue;
            }
            if (element == DefaultVertexFormat.f_85806_) {
                this.uv.ifPresent(uv -> this.delegate.m_7421_(uv.f_82470_, uv.f_82471_));
                continue;
            }
            if (element == DefaultVertexFormat.f_85807_) {
                this.overlay.ifPresent(overlay -> this.delegate.m_7122_(overlay.x, overlay.y));
                continue;
            }
            if (element == DefaultVertexFormat.f_85808_) {
                this.lightmap.ifPresent(lightmap -> this.delegate.m_7120_(lightmap.x, lightmap.y));
                continue;
            }
            if (element != DefaultVertexFormat.f_85809_) continue;
            this.normal.ifPresent(normal -> this.delegate.m_85977_(this.transform.m_85850_().m_85864_(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_()));
        }
        this.delegate.m_5752_();
        this.allObjects.forEach(ObjectWithGlobal::clear);
    }

    public void defaultColor(float r, float g, float b, float a) {
        this.color.setGlobal(new Vector4f(r, g, b, a));
    }

    public void m_142461_(int r, int g, int b, int a) {
        this.defaultColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public void m_141991_() {
        this.color.setGlobal(null);
    }

    public TransformingVertexBuilder setLight(int light) {
        this.lightmap.setGlobal(new Vec2i(light & 0xFF, light >> 16));
        return this.getThis();
    }

    public TransformingVertexBuilder setNormal(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        vec.m_122278_();
        this.normal.setGlobal(vec);
        return this.getThis();
    }

    public TransformingVertexBuilder setNormal(Vec3 normal) {
        return this.setNormal((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
    }

    public TransformingVertexBuilder setOverlay(int packedOverlayIn) {
        this.overlay.setGlobal(new Vec2i(packedOverlayIn & 0xFFFF, packedOverlayIn >> 16));
        return this.getThis();
    }

    @Override
    protected TransformingVertexBuilder getThis() {
        return this;
    }

    public TransformingVertexBuilder setColor(int color) {
        this.defaultColor((float)BitUtils.getBits(color, 16, 8) / 255.0f, (float)BitUtils.getBits(color, 8, 8) / 255.0f, (float)BitUtils.getBits(color, 0, 8) / 255.0f, (float)BitUtils.getBits(color, 24, 8) / 255.0f);
        return this;
    }

    protected class ObjectWithGlobal<T> {
        @Nullable
        private T obj;
        private boolean isGlobal;

        public ObjectWithGlobal() {
            TransformingVertexBuilder.this.allObjects.add(this);
        }

        public void putData(T newVal) {
            if (this.obj == null) {
                this.obj = newVal;
            }
        }

        public void setGlobal(@Nullable T obj) {
            this.obj = obj;
            this.isGlobal = obj != null;
        }

        public T read() {
            Object ret = Preconditions.checkNotNull(this.obj);
            this.clear();
            return (T)ret;
        }

        public boolean hasValue() {
            return this.obj != null;
        }

        public void clear() {
            if (!this.isGlobal) {
                this.obj = null;
            }
        }

        public void ifPresent(Consumer<T> out) {
            if (this.hasValue()) {
                out.accept(this.read());
            }
        }
    }

    private record Vec2i(int x, int y) {
    }
}

