/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.serial.PacketBufferStorage;
import malte0811.controlengineering.util.typereg.TypedInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public final class PanelComponentInstance<Config, State>
extends TypedInstance<Pair<Config, State>, PanelComponentType<Config, State>> {
    public static final MyCodec<PanelComponentInstance<?, ?>> CODEC = TypedInstance.makeCodec(PanelComponents.REGISTRY);

    public PanelComponentInstance(PanelComponentType<Config, State> type, Pair<Config, State> state) {
        super(type, state);
    }

    public PanelComponentInstance(PanelComponentType<Config, State> type, Config config, State state) {
        super(type, Pair.of(config, state));
    }

    @Nullable
    public static PanelComponentInstance<?, ?> readFrom(FriendlyByteBuf buffer) {
        ResourceLocation typeName;
        try {
            typeName = buffer.m_130281_();
        }
        catch (Exception x) {
            return null;
        }
        PanelComponentType<?, ?> type = PanelComponents.REGISTRY.get(typeName);
        if (type == null) {
            return null;
        }
        return type.newInstance(buffer);
    }

    public InteractionResult onClick(PanelComponentType.ComponentClickContext ctx, boolean isClient) {
        Pair<InteractionResult, State> clickResult = ((PanelComponentType)this.getType()).click(this.getConfig(), this.getState(), ctx);
        if (!isClient) {
            this.currentState = Pair.of(this.getConfig(), (Object)clickResult.getSecond());
        }
        return (InteractionResult)clickResult.getFirst();
    }

    public TickResult tick() {
        Pair oldState = (Pair)this.currentState;
        this.currentState = Pair.of(this.getConfig(), ((PanelComponentType)this.getType()).tick(this.getConfig(), this.getState()));
        return new TickResult(!Objects.equals(oldState, this.currentState), ((PanelComponentType)this.getType()).canClientDistinguish(oldState.getSecond(), ((Pair)this.currentState).getSecond()));
    }

    public BusState getEmittedState() {
        return ((PanelComponentType)this.getType()).getEmittedState(this.getConfig(), this.getState());
    }

    public Config getConfig() {
        return (Config)((Pair)this.currentState).getFirst();
    }

    public void writeToWithoutState(FriendlyByteBuf buffer) {
        buffer.m_130085_(((PanelComponentType)this.getType()).getRegistryName());
        ((PanelComponentType)this.getType()).getConfigCodec().toSerial(new PacketBufferStorage(buffer), this.getConfig());
    }

    public State getState() {
        return (State)((Pair)this.currentState).getSecond();
    }

    public void updateTotalState(BusState totalState) {
        State newState = ((PanelComponentType)this.getType()).updateTotalState(this.getConfig(), this.getState(), totalState);
        this.currentState = Pair.of(this.getConfig(), newState);
    }

    public PanelComponentInstance<?, ?> copy(boolean clearState) {
        Object stateToUse = ((Pair)this.currentState).getSecond();
        if (clearState) {
            stateToUse = ((PanelComponentType)this.getType()).updateTotalState(this.getConfig(), stateToUse, BusState.EMPTY);
        }
        return new PanelComponentInstance<Config, State>((PanelComponentType)this.getType(), Pair.of(this.getConfig(), (Object)stateToUse));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PanelComponentInstance)) {
            return false;
        }
        PanelComponentInstance inst = (PanelComponentInstance)obj;
        return this.getType() == inst.getType() && this.getConfig().equals(inst.getConfig()) && this.getState().equals(inst.getState());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getConfig(), this.getState());
    }

    public List<String> toCNCStrings() {
        return ((PanelComponentType)this.getType()).toCNCStrings(this.getConfig());
    }

    public void setConfig(Config newConfig) {
        this.currentState = Pair.of(newConfig, this.getState());
    }

    public Vec2d getSize(Level level) {
        return ((PanelComponentType)this.getType()).getSize(this.getConfig(), level);
    }

    public String toString() {
        return "type=" + this.getType() + ";config=" + this.getConfig() + ";state=" + this.getState();
    }

    public AABB getSelectionShape() {
        return ((PanelComponentType)this.getType()).getSelectionShape(this.getState());
    }

    public record TickResult(boolean updateBus, boolean updateClient) {
    }
}

