/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.crafting.noncrafting.ComponentCostRecipe;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.RecordCodecBase;
import malte0811.controlengineering.util.mycodec.serial.PacketBufferStorage;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.serial.StringListStorage;
import malte0811.controlengineering.util.typereg.TypedRegistryEntry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class PanelComponentType<Config, State>
extends TypedRegistryEntry<Pair<Config, State>, PanelComponentInstance<Config, State>> {
    @Nullable
    private final Vec2d size;
    private final RecordCodecBase<Config> configCodec;
    private String translationKey;
    private final AABB defaultSelectionShape;

    protected PanelComponentType(Config defaultConfig, State intitialState, RecordCodecBase<Config> codecConfig, MyCodec<State> codecState, @Nullable Vec2d size, double selectionHeight) {
        super(Pair.of(defaultConfig, intitialState), MyCodecs.pair(codecConfig, codecState));
        this.size = size;
        this.configCodec = codecConfig;
        this.defaultSelectionShape = selectionHeight >= 0.0 && size != null ? new AABB(0.0, 0.0, 0.0, size.x(), selectionHeight, size.y()) : null;
    }

    @Override
    public PanelComponentInstance<Config, State> newInstance(Pair<Config, State> state) {
        return new PanelComponentInstance<Config, State>(this, state);
    }

    public PanelComponentInstance<Config, State> newInstanceFromCfg(Config config) {
        return new PanelComponentInstance(this, Pair.of(config, (Object)((Pair)this.getInitialState()).getSecond()));
    }

    @Override
    @Nullable
    public PanelComponentInstance<Config, State> newInstance(FriendlyByteBuf from) {
        return this.newInstance(new PacketBufferStorage(from)).orElse(null);
    }

    @Override
    public FastDataResult<PanelComponentInstance<Config, State>> newInstance(List<String> data) {
        return this.newInstance(new StringListStorage(data));
    }

    @Override
    private FastDataResult<PanelComponentInstance<Config, State>> newInstance(SerialStorage data) {
        return this.configCodec.fromSerial(data).map(this::newInstanceFromCfg);
    }

    public List<String> toCNCStrings(Config config) {
        StringListStorage storage = new StringListStorage();
        this.configCodec.toSerial(storage, config);
        return storage.getData();
    }

    public BusState getEmittedState(Config config, State state) {
        return BusState.EMPTY;
    }

    public State updateTotalState(Config config, State oldState, BusState busState) {
        return oldState;
    }

    public State tick(Config config, State oldState) {
        return oldState;
    }

    public Pair<InteractionResult, State> click(Config config, State oldState, ComponentClickContext ctx) {
        return Pair.of((Object)InteractionResult.PASS, oldState);
    }

    @Nullable
    public AABB getSelectionShape(State state) {
        return this.defaultSelectionShape;
    }

    public Vec2d getSize(Config config, Level level) {
        return Objects.requireNonNull(this.size);
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            ResourceLocation name = this.getRegistryName();
            this.translationKey = name.m_135827_() + ".component." + name.m_135815_();
        }
        return this.translationKey;
    }

    public boolean canClientDistinguish(State stateA, State stateB) {
        return !Objects.equals(stateA, stateB);
    }

    public final List<IngredientWithSize> getCost(Level level) {
        Recipe recipe;
        if (level != null && (recipe = (Recipe)level.m_7465_().m_44043_(this.getCostLocation()).orElse(null)) instanceof ComponentCostRecipe) {
            ComponentCostRecipe componentCost = (ComponentCostRecipe)recipe;
            return componentCost.getCost();
        }
        return List.of(new IngredientWithSize(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41829_})));
    }

    public final RecordCodecBase<Config> getConfigCodec() {
        return this.configCodec;
    }

    public ResourceLocation getCostLocation() {
        return new ResourceLocation(this.getRegistryName().m_135827_(), "component_cost/" + this.getRegistryName().m_135815_());
    }

    protected static <T> Pair<InteractionResult, T> success(T newState) {
        return Pair.of((Object)InteractionResult.SUCCESS, newState);
    }

    protected static <T> Pair<InteractionResult, T> pass(T newState) {
        return Pair.of((Object)InteractionResult.PASS, newState);
    }

    public record ComponentClickContext(Vec3 relativeHit, @Nullable Player player, InteractionHand hand) {
        public boolean isSneaking() {
            return this.player != null && this.player.m_6144_();
        }

        public ItemStack getHeldItem() {
            return this.player == null ? ItemStack.f_41583_ : this.player.m_21120_(this.hand);
        }
    }
}

