/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import javax.annotation.Nullable;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.components.Button;
import malte0811.controlengineering.controlpanels.components.CoveredToggleSwitch;
import malte0811.controlengineering.controlpanels.components.Indicator;
import malte0811.controlengineering.controlpanels.components.KeySwitch;
import malte0811.controlengineering.controlpanels.components.Label;
import malte0811.controlengineering.controlpanels.components.PanelMeter;
import malte0811.controlengineering.controlpanels.components.Slider;
import malte0811.controlengineering.controlpanels.components.TimedButton;
import malte0811.controlengineering.controlpanels.components.ToggleSwitch;
import malte0811.controlengineering.controlpanels.components.Variac;
import malte0811.controlengineering.util.typereg.TypedRegistry;
import net.minecraft.resources.ResourceLocation;

public class PanelComponents {
    public static final TypedRegistry<PanelComponentType<?, ?>> REGISTRY = new TypedRegistry();
    private static final BiMap<String, ResourceLocation> CREATION_KEY = HashBiMap.create();
    public static final Button BUTTON = PanelComponents.register("button", new Button());
    public static final TimedButton TIMED_BUTTON = PanelComponents.register("timed_button", new TimedButton());
    public static final ToggleSwitch TOGGLE_SWITCH = PanelComponents.register("toggle_switch", new ToggleSwitch());
    public static final CoveredToggleSwitch COVERED_SWITCH = PanelComponents.register("covered_switch", new CoveredToggleSwitch());
    public static final Variac VARIAC = PanelComponents.register("variac", new Variac());
    public static final Slider SLIDER_HOR = PanelComponents.register("slider_hor", new Slider(true));
    public static final Slider SLIDER_VERT = PanelComponents.register("slider_vert", new Slider(false));
    public static final KeySwitch KEY_SWITCH = PanelComponents.register("key_switch", new KeySwitch());
    public static final Indicator INDICATOR = PanelComponents.register("indicator", new Indicator());
    public static final PanelMeter PANEL_METER = PanelComponents.register("panel_meter", new PanelMeter());
    public static final Label LABEL = PanelComponents.register("label", new Label());

    private static <T extends PanelComponentType<?, ?>> T register(String path, T type) {
        ResourceLocation nameRL = new ResourceLocation("controlengineering", path);
        CREATION_KEY.put((Object)path, (Object)nameRL);
        return REGISTRY.register(nameRL, type);
    }

    public static PanelComponentType<?, ?> getType(ResourceLocation id) {
        return (PanelComponentType)Preconditions.checkNotNull(REGISTRY.get(id));
    }

    public static String getCreationKey(PanelComponentType<?, ?> type) {
        return (String)CREATION_KEY.inverse().get((Object)type.getRegistryName());
    }

    @Nullable
    public static PanelComponentType<?, ?> getType(String id) {
        ResourceLocation name = (ResourceLocation)CREATION_KEY.get((Object)id);
        if (name != null) {
            return PanelComponents.getType(name);
        }
        return null;
    }
}

