/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import malte0811.controlengineering.blockentity.panels.ControlPanelBlockEntity;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PanelData {
    private final List<PlacedComponent> components;
    private final PanelTransform transform;

    public PanelData(List<PlacedComponent> components, PanelTransform transform) {
        this.components = components;
        this.transform = transform;
    }

    public PanelData() {
        this((List<PlacedComponent>)ImmutableList.of(), new PanelTransform());
    }

    public PanelData(CompoundTag nbt, PanelOrientation orientation) {
        this(PlacedComponent.readListFromNBT((Tag)nbt.m_128437_("components", 10)), PanelTransform.from(nbt, orientation));
    }

    public PanelData(ControlPanelBlockEntity bEntity) {
        this(bEntity.getComponents(), bEntity.getTransform());
    }

    public CompoundTag toNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128365_("components", PlacedComponent.writeListToNBT(this.getComponents()));
        this.getTransform().addTo(result);
        return result;
    }

    public List<PlacedComponent> getComponents() {
        return this.components;
    }

    public PanelData copy(boolean clearState) {
        ArrayList<PlacedComponent> copiedComponents = new ArrayList<PlacedComponent>(this.components.size());
        for (PlacedComponent component : this.components) {
            copiedComponents.add(component.copy(clearState));
        }
        return new PanelData(copiedComponents, this.getTransform());
    }

    public PanelTransform getTransform() {
        return this.transform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PanelData panelData = (PanelData)o;
        return Objects.equals(this.components, panelData.components) && Objects.equals(this.transform, panelData.transform);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.transform);
    }
}

