/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.panels.ControlPanelBlockEntity;
import malte0811.controlengineering.blocks.panels.CachedPanelShape;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.util.BEUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanelSelectionShapes
extends SelectionShapes {
    private final ControlPanelBlockEntity bEntity;

    public PanelSelectionShapes(ControlPanelBlockEntity bEntity) {
        this.bEntity = bEntity;
    }

    @Override
    @Nullable
    public VoxelShape mainShape() {
        return CachedPanelShape.getPanelShape(this.bEntity.getTransform());
    }

    @Override
    @Nonnull
    public Matrix4f outerToInnerPosition() {
        return this.bEntity.getTransform().getWorldToPanelTop();
    }

    @Override
    @Nonnull
    public List<? extends SelectionShapes> innerShapes() {
        return this.bEntity.getComponents();
    }

    @Override
    public void plotBox(BiConsumer<Vec3, Vec3> drawLine) {
        PanelTransform transform = this.bEntity.getTransform();
        Vec3[] bottomVertices = transform.getBottomVertices();
        Vec3[] topVertices = transform.getTopVertices();
        for (int i = 0; i < 4; ++i) {
            drawLine.accept(bottomVertices[i], bottomVertices[(i + 1) % 4]);
            drawLine.accept(topVertices[i], topVertices[(i + 1) % 4]);
            drawLine.accept(bottomVertices[i], topVertices[i]);
        }
    }

    @Override
    public InteractionResult onUse(UseOnContext ctx, InteractionResult defaultType, Vec3 relativeHit) {
        if (defaultType.m_19080_() && !this.bEntity.m_58904_().f_46443_) {
            this.bEntity.updateBusState();
            this.bEntity.m_6596_();
            BEUtil.markDirtyAndSync(this.bEntity);
        }
        return defaultType;
    }

    @Override
    public boolean shouldRenderNonTop() {
        return true;
    }

    @Override
    public boolean allowTargetThroughOuter() {
        return true;
    }
}

