/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.mojang.math.Matrix4f;
import java.util.Objects;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.controlpanels.TransformCaches;
import malte0811.controlengineering.util.math.MatrixUtils;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class PanelTransform {
    private static final MyCodec<BETransformData> CODEC = new RecordCodec2<BETransformData, Float, Float>(new CodecField<BETransformData, Float>("height", p -> Float.valueOf(p.centerHeight), MyCodecs.FLOAT), new CodecField<BETransformData, Float>("angle", p -> Float.valueOf(p.degrees), MyCodecs.FLOAT), BETransformData::new);
    private final BETransformData bEntityData;
    private final Matrix4f panelTopToWorld;
    private final Matrix4f panelBottomToWorld;
    private final Matrix4f worldToPanelTop;

    public PanelTransform(float centerHeight, float degrees, PanelOrientation blockData) {
        this(new BETransformData(centerHeight, degrees), blockData);
    }

    public PanelTransform(BETransformData bEntityData, PanelOrientation blockData) {
        this.bEntityData = bEntityData;
        float radians = (float)Math.toRadians(bEntityData.degrees);
        float borderHeight = this.getFrontHeight();
        this.panelBottomToWorld = TransformCaches.makePanelBottomToWorld(blockData);
        this.panelTopToWorld = this.panelBottomToWorld.m_27658_();
        this.panelTopToWorld.m_27644_(TransformCaches.makePanelTopToPanelBottom(borderHeight, radians));
        this.worldToPanelTop = TransformCaches.makePanelBottomToPanelTop(borderHeight, radians).m_27658_();
        this.worldToPanelTop.m_27644_(TransformCaches.makeWorldToPanelBottom(blockData));
    }

    public PanelTransform() {
        this(0.25f, (float)Math.toDegrees(Math.atan(0.5)), PanelOrientation.DOWN_NORTH);
    }

    public static PanelTransform withHeights(float frontHeight, float backHeight, PanelOrientation orientation) {
        float centerHeight = (frontHeight + backHeight) / 2.0f;
        double angle = Math.atan(backHeight - frontHeight);
        return new PanelTransform(centerHeight, (float)Math.toDegrees(angle), orientation);
    }

    public Matrix4f getPanelBottomToWorld() {
        return this.panelBottomToWorld;
    }

    public Matrix4f getPanelTopToWorld() {
        return this.panelTopToWorld;
    }

    public Matrix4f getWorldToPanelTop() {
        return this.worldToPanelTop;
    }

    public double getTopFaceHeight() {
        return 1.0 / Math.cos(Math.toRadians(this.bEntityData.degrees));
    }

    public void addTo(CompoundTag out) {
        out.m_128365_("transform", CODEC.toNBT(this.bEntityData));
    }

    public float getFrontHeight() {
        double radians = Math.toRadians(this.bEntityData.degrees);
        return (float)((double)this.bEntityData.centerHeight - Math.tan(radians) / 2.0);
    }

    public float getBackHeight() {
        double radians = Math.toRadians(this.bEntityData.degrees);
        return (float)((double)this.bEntityData.centerHeight + Math.tan(radians) / 2.0);
    }

    public static PanelTransform from(CompoundTag nbt, PanelOrientation orientation) {
        BETransformData beData = CODEC.fromNBT(nbt.m_128423_("transform"), BETransformData::new);
        return new PanelTransform(beData, orientation);
    }

    public double getCenterHeight() {
        return this.bEntityData.centerHeight;
    }

    public Vec3[] getBottomVertices() {
        Vec3[] bottomVertices = PanelTransform.layerVertices(1.0);
        for (int i = 0; i < 4; ++i) {
            bottomVertices[i] = MatrixUtils.transform(this.getPanelBottomToWorld(), bottomVertices[i]);
        }
        return bottomVertices;
    }

    public Vec3[] getTopVertices() {
        Vec3[] topVertices = PanelTransform.layerVertices(this.getTopFaceHeight());
        for (int i = 0; i < 4; ++i) {
            topVertices[i] = MatrixUtils.transform(this.getPanelTopToWorld(), topVertices[i]);
        }
        Vec3 temp = topVertices[0];
        System.arraycopy(topVertices, 1, topVertices, 0, topVertices.length - 1);
        topVertices[topVertices.length - 1] = temp;
        return topVertices;
    }

    public static Vec3[] layerVertices(double xMax) {
        return new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.0, xMax), new Vec3(0.0, 0.0, xMax)};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PanelTransform that = (PanelTransform)o;
        return this.bEntityData.equals(that.bEntityData) && this.panelTopToWorld.equals((Object)that.panelTopToWorld) && this.panelBottomToWorld.equals((Object)that.panelBottomToWorld) && this.worldToPanelTop.equals((Object)that.worldToPanelTop);
    }

    public int hashCode() {
        return Objects.hash(this.bEntityData, this.panelTopToWorld, this.panelBottomToWorld, this.worldToPanelTop);
    }

    private record BETransformData(float centerHeight, float degrees) {
        private BETransformData() {
            this(0.25f, (float)(-Math.toDegrees(Math.atan(0.5))));
        }
    }
}

