/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.util.math.RectangleD;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;

public class PlacedComponent
extends SelectionShapes {
    public static final MyCodec<PlacedComponent> CODEC = new RecordCodec2<PlacedComponent, PanelComponentInstance, Vec2d>(new CodecField("component", pc -> pc.component, PanelComponentInstance.CODEC), new CodecField<PlacedComponent, Vec2d>("position", pc -> pc.pos, Vec2d.CODEC), PlacedComponent::new);
    public static final MyCodec<List<PlacedComponent>> LIST_CODEC = MyCodecs.list(CODEC);
    @Nonnull
    private final PanelComponentInstance<?, ?> component;
    @Nonnull
    private final Vec2d pos;
    private final Lazy<AABB> shape;

    public PlacedComponent(@Nonnull PanelComponentInstance<?, ?> component, @Nonnull Vec2d pos) {
        this.component = component;
        this.pos = pos;
        this.shape = Lazy.of(() -> {
            AABB compShape = component.getSelectionShape();
            if (compShape == null) {
                return null;
            }
            return PlacedComponent.scale(compShape.m_82386_(pos.x(), 0.0, pos.y()), 0.0625);
        });
    }

    @Nullable
    public static PlacedComponent readWithoutState(FriendlyByteBuf from) {
        Vec2d pos = new Vec2d(from);
        PanelComponentInstance<?, ?> instance = PanelComponentInstance.readFrom(from);
        if (instance == null) {
            return null;
        }
        return new PlacedComponent(instance, pos);
    }

    public void writeToWithoutState(FriendlyByteBuf buffer) {
        this.pos.write(buffer);
        this.getComponent().writeToWithoutState(buffer);
    }

    @Nonnull
    public PanelComponentInstance<?, ?> getComponent() {
        return this.component;
    }

    @Nonnull
    public Vec2d getPosMin() {
        return this.pos;
    }

    @Nonnull
    public Vec2d getPosMax(Level level) {
        return this.pos.add(this.component.getSize(level));
    }

    public RectangleD getOutline(Level level) {
        return new RectangleD(this.getPosMin(), this.getPosMax(level));
    }

    @Nullable
    public AABB getSelectionShape() {
        return (AABB)this.shape.get();
    }

    private static AABB scale(AABB in, double scale) {
        return new AABB(in.f_82288_ * scale, in.f_82289_ * scale, in.f_82290_ * scale, in.f_82291_ * scale, in.f_82292_ * scale, in.f_82293_ * scale);
    }

    @Override
    @Nullable
    public VoxelShape mainShape() {
        AABB selectionShape = this.getSelectionShape();
        if (selectionShape != null) {
            return Shapes.m_83064_((AABB)selectionShape);
        }
        return null;
    }

    @Override
    @Nonnull
    public Matrix4f outerToInnerPosition() {
        Matrix4f id = new Matrix4f();
        id.m_27624_();
        return id;
    }

    @Override
    @Nonnull
    public List<? extends SelectionShapes> innerShapes() {
        return ImmutableList.of();
    }

    @Override
    public InteractionResult onUse(UseOnContext ctx, InteractionResult defaultType, Vec3 relativeHit) {
        return this.component.onClick(new PanelComponentType.ComponentClickContext(relativeHit.m_82490_(16.0).m_82492_(this.pos.x(), 0.0, this.pos.y()), ctx.m_43723_(), ctx.m_43724_()), ctx.m_43725_().m_5776_());
    }

    public PanelComponentInstance.TickResult tick() {
        return this.component.tick();
    }

    public boolean disjoint(Level level, PlacedComponent other) {
        return this.getOutline(level).disjoint(other.getOutline(level));
    }

    public boolean isWithinPanel(Level level) {
        return new RectangleD(0.0, 0.0, 16.0, 16.0).contains(this.getOutline(level));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacedComponent that = (PlacedComponent)o;
        return this.component.equals(that.component) && this.pos.equals(that.pos);
    }

    public int hashCode() {
        return Objects.hash(this.component, this.pos);
    }

    public PlacedComponent copy(boolean clearState) {
        return new PlacedComponent(this.component.copy(clearState), this.pos);
    }

    public static List<PlacedComponent> readListFromNBT(Tag list) {
        return LIST_CODEC.fromNBT(list, List::of);
    }

    public static Tag writeListToNBT(List<PlacedComponent> components) {
        return LIST_CODEC.toNBT(components);
    }

    public static int getIndexAt(Level level, List<PlacedComponent> components, double x, double y) {
        for (int i = 0; i < components.size(); ++i) {
            PlacedComponent p = components.get(i);
            if (!p.getOutline(level).containsClosed(x, y)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return new StringJoiner(", ", PlacedComponent.class.getSimpleName() + "[", "]").add("component=" + this.component).add("pos=" + this.pos).toString();
    }
}

