/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.util.EnumMap;
import java.util.Map;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.Direction;

public class TransformCaches {
    private static final Quaternion QUARTER_Y = new Quaternion(0.0f, 1.5707964f, 0.0f, false);
    private static final Quaternion MINUS_QUARTER_Y = new Quaternion(0.0f, -1.5707964f, 0.0f, false);
    private static final Quaternion MINUS_QUARTER_X = new Quaternion(-1.5707964f, 0.0f, 0.0f, false);
    private static final Map<PanelOrientation, Matrix4f> PANEL_BOTTOM_TO_WORLD = new EnumMap<PanelOrientation, Matrix4f>(PanelOrientation.class);
    private static final Map<PanelOrientation, Matrix4f> WORLD_TO_PANEL_BOTTOM = new EnumMap<PanelOrientation, Matrix4f>(PanelOrientation.class);
    private static final LoadingCache<PanelTopState, Matrix4f> PANEL_TOP_TO_BOTTOM = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(pts -> {
        Matrix4f panelTopToPanelBottom = new Matrix4f();
        panelTopToPanelBottom.m_27624_();
        panelTopToPanelBottom.m_162199_(0.0f, pts.borderHeight, 0.0f);
        panelTopToPanelBottom.m_27646_(new Quaternion(0.0f, 0.0f, pts.angle, false));
        panelTopToPanelBottom.m_162199_(0.5f, 0.0f, 0.5f);
        panelTopToPanelBottom.m_27646_(QUARTER_Y);
        panelTopToPanelBottom.m_162199_(-0.5f, 0.0f, -0.5f);
        return panelTopToPanelBottom;
    }));
    private static final LoadingCache<PanelTopState, Matrix4f> PANEL_BOTTOM_TO_TOP = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(pts -> {
        Matrix4f temp = ((Matrix4f)PANEL_TOP_TO_BOTTOM.getUnchecked(pts)).m_27658_();
        temp.m_27657_();
        return temp;
    }));

    public static Matrix4f makePanelBottomToWorld(PanelOrientation bd) {
        return PANEL_BOTTOM_TO_WORLD.computeIfAbsent(bd, blockData -> {
            Matrix4f panelBottomToWorld = new Matrix4f();
            panelBottomToWorld.m_27624_();
            panelBottomToWorld.m_162199_(0.5f, 0.5f, 0.5f);
            MatrixUtils.rotateFacing(panelBottomToWorld, blockData.top, 1.0f);
            panelBottomToWorld.m_27646_(MINUS_QUARTER_X);
            if (blockData.top == Direction.DOWN) {
                MatrixUtils.rotateFacing(panelBottomToWorld, blockData.front, -1.0f);
            } else {
                MatrixUtils.rotateFacing(panelBottomToWorld, blockData.front, 1.0f);
            }
            panelBottomToWorld.m_27646_(MINUS_QUARTER_Y);
            panelBottomToWorld.m_162199_(-0.5f, -0.5f, -0.5f);
            return panelBottomToWorld;
        });
    }

    public static Matrix4f makePanelTopToPanelBottom(float borderHeight, float radians) {
        return (Matrix4f)PANEL_TOP_TO_BOTTOM.getUnchecked((Object)new PanelTopState(borderHeight, radians));
    }

    public static Matrix4f makePanelBottomToPanelTop(float borderHeight, float radians) {
        return (Matrix4f)PANEL_BOTTOM_TO_TOP.getUnchecked((Object)new PanelTopState(borderHeight, radians));
    }

    public static Matrix4f makeWorldToPanelBottom(PanelOrientation bd) {
        return WORLD_TO_PANEL_BOTTOM.computeIfAbsent(bd, blockData -> {
            Matrix4f as4f = TransformCaches.makePanelBottomToWorld(blockData).m_27658_();
            as4f.m_27657_();
            return as4f;
        });
    }

    private record PanelTopState(float borderHeight, float angle) {
    }
}

