/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.cnc;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.PlacedComponent;

public class CNCInstructionGenerator {
    public static String toInstructions(List<PlacedComponent> components) {
        StringBuilder result = new StringBuilder();
        for (PlacedComponent comp : components) {
            if (result.length() > 0) {
                result.append(';');
            }
            CNCInstructionGenerator.toInstructions(result, comp);
        }
        return result.toString();
    }

    public static StringBuilder toInstructions(StringBuilder out, PlacedComponent component) {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(Locale.ROOT);
        DecimalFormat format = new DecimalFormat("#.##", decimalSymbols);
        out.append(PanelComponents.getCreationKey((PanelComponentType)component.getComponent().getType())).append(' ').append(format.format(component.getPosMin().x())).append(' ').append(format.format(component.getPosMin().y()));
        for (String field : component.getComponent().toCNCStrings()) {
            out.append(' ').append(CNCInstructionGenerator.escape(field));
        }
        return out;
    }

    private static String escape(String raw) {
        String escaped = raw.chars().mapToObj(i -> {
            if (i == 92) {
                return "\\\\";
            }
            if (i == 34) {
                return "\\\"";
            }
            return "" + (char)i;
        }).collect(Collectors.joining());
        if (escaped.chars().anyMatch(Character::isWhitespace)) {
            return "\"" + escaped + "\"";
        }
        return escaped;
    }
}

