/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.cnc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.world.level.Level;

public class CNCInstructionParser {
    public static final char ESCAPE = '\\';
    public static final char COMPONENT_SEPARATOR = ';';
    public static final char QUOTATION_MARK = '\"';

    public static ParserResult parse(Level level, String input) {
        int pos = 0;
        Object error = null;
        ArrayList<PlacedComponent> components = new ArrayList<PlacedComponent>();
        IntArrayList componentEnds = new IntArrayList();
        while (pos < input.length()) {
            int componentStart = pos;
            Pair<String, Integer> next = CNCInstructionParser.nextComponent(input, pos);
            String componentString = (String)next.getFirst();
            pos = (Integer)next.getSecond();
            FastDataResult<List<String>> tokens = CNCInstructionParser.tokenize(componentString);
            if (tokens.isError()) {
                error = tokens.getErrorMessage();
                break;
            }
            if (tokens.get().size() < 3) {
                error = "Too few tokens in component starting at " + componentStart;
                break;
            }
            FastDataResult<PlacedComponent> nextRes = CNCInstructionParser.parseComponent(level, tokens.get());
            if (nextRes.isError()) {
                error = "Component starting at " + componentStart + ": " + nextRes.getErrorMessage();
                break;
            }
            PlacedComponent next2 = nextRes.get();
            for (PlacedComponent existing : components) {
                if (existing.disjoint(level, next2)) continue;
                error = "Component starting at " + componentStart + " intersects previous component";
            }
            if (error != null) break;
            components.add(next2);
            componentEnds.add(pos);
        }
        if (error != null) {
            return ParserResult.failure(components, (IntList)componentEnds, error);
        }
        return ParserResult.success(components, (IntList)componentEnds);
    }

    private static FastDataResult<PlacedComponent> parseComponent(Level level, List<String> tokens) {
        double y;
        double x;
        String typeName = tokens.get(0);
        PanelComponentType<?, ?> type = PanelComponents.getType(typeName);
        if (type == null) {
            return FastDataResult.error("Unknown type: " + typeName);
        }
        try {
            x = Double.parseDouble(tokens.get(1));
            y = Double.parseDouble(tokens.get(2));
        }
        catch (NumberFormatException xcp) {
            return FastDataResult.error("Invalid position");
        }
        FastDataResult<PanelComponentInstance<?, ?>> component = type.newInstance(tokens.subList(3, tokens.size()));
        if (component.isError()) {
            return component.propagateError();
        }
        PlacedComponent placed = new PlacedComponent(component.get(), new Vec2d(x, y));
        if (!placed.isWithinPanel(level)) {
            return FastDataResult.error("Not within panel bounds");
        }
        return FastDataResult.success(placed);
    }

    private static Pair<String, Integer> nextComponent(String input, int start) {
        int nextSep = -1;
        boolean inQuotes = false;
        block5: for (int i = start; nextSep < 0 && i < input.length(); ++i) {
            char next = input.charAt(i);
            switch (next) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case '\\': {
                    ++i;
                    continue block5;
                }
                case ';': {
                    if (inQuotes) continue block5;
                    nextSep = i;
                }
            }
        }
        if (nextSep >= 0) {
            return Pair.of((Object)input.substring(start, nextSep), (Object)(nextSep + 1));
        }
        return Pair.of((Object)input.substring(start), (Object)input.length());
    }

    private static FastDataResult<List<String>> tokenize(String input) {
        int pos = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (pos < input.length()) {
            FastDataResult<Pair<String, Integer>> p = CNCInstructionParser.nextToken(input, pos);
            if (p.isError()) {
                return p.propagateError();
            }
            pos = (Integer)p.get().getSecond();
            result.add((String)p.get().getFirst());
        }
        return FastDataResult.success(result);
    }

    private static FastDataResult<Pair<String, Integer>> nextToken(String input, int start) {
        boolean untilQuotationMarks;
        int currentPos;
        for (currentPos = start; currentPos < input.length() && Character.isWhitespace(input.charAt(currentPos)); ++currentPos) {
        }
        StringBuilder result = new StringBuilder();
        boolean bl = untilQuotationMarks = input.charAt(currentPos) == '\"';
        if (untilQuotationMarks) {
            ++currentPos;
        }
        boolean isEscaped = false;
        while (currentPos < input.length() && (isEscaped || !CNCInstructionParser.shouldStop(input.charAt(currentPos), untilQuotationMarks))) {
            char next = input.charAt(currentPos);
            if (isEscaped || next != '\\') {
                result.append(next);
                isEscaped = false;
            } else {
                isEscaped = true;
            }
            ++currentPos;
        }
        if (isEscaped) {
            return FastDataResult.error("Tape ends in escape sequence");
        }
        if (untilQuotationMarks && currentPos >= input.length()) {
            return FastDataResult.error("Unterminated quoted parameter starting at " + start);
        }
        if (!untilQuotationMarks && currentPos < input.length() && !Character.isWhitespace(input.charAt(currentPos))) {
            result.append(input.charAt(currentPos));
        }
        return FastDataResult.success(Pair.of((Object)result.toString(), (Object)(++currentPos)));
    }

    private static boolean shouldStop(char c, boolean untilQuot) {
        if (untilQuot) {
            return c == '\"';
        }
        return Character.isWhitespace(c);
    }

    public record ParserResult(ImmutableList<PlacedComponent> components, IntList componentEnds, @Nullable String error) {
        private ParserResult(List<PlacedComponent> components, IntList componentEnds, @Nullable String error) {
            this((ImmutableList<PlacedComponent>)ImmutableList.copyOf(components), IntLists.unmodifiable((IntList)componentEnds), error);
        }

        public static ParserResult success(List<PlacedComponent> components, IntList componentEnds) {
            return new ParserResult(components, componentEnds, null);
        }

        public static ParserResult failure(List<PlacedComponent> components, IntList componentEnds, String error) {
            Preconditions.checkNotNull((Object)error);
            return new ParserResult(components, componentEnds, error);
        }

        public boolean isError() {
            return this.error != null;
        }
    }
}

