/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.components;

import com.mojang.datafixers.util.Pair;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.components.ToggleSwitch;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.world.InteractionResult;

public class CoveredToggleSwitch
extends PanelComponentType<ColorAndSignal, State> {
    public CoveredToggleSwitch() {
        super(new ColorAndSignal(0xFF0000, BusSignalRef.DEFAULT), State.CLOSED, ColorAndSignal.CODEC, State.CODEC, ToggleSwitch.SIZE, 1.5);
    }

    @Override
    public BusState getEmittedState(ColorAndSignal config, State state) {
        if (state == State.ACTIVE) {
            return config.signal().singleSignalState(255);
        }
        return BusState.EMPTY;
    }

    @Override
    public Pair<InteractionResult, State> click(ColorAndSignal config, State oldState, PanelComponentType.ComponentClickContext ctx) {
        if (ctx.isSneaking()) {
            return Pair.of((Object)(oldState == State.CLOSED ? InteractionResult.PASS : InteractionResult.SUCCESS), (Object)((Object)State.CLOSED));
        }
        State newState = switch (oldState) {
            default -> throw new IncompatibleClassChangeError();
            case State.CLOSED -> State.OPEN;
            case State.OPEN -> State.ACTIVE;
            case State.ACTIVE -> State.CLOSED;
        };
        return Pair.of((Object)InteractionResult.SUCCESS, (Object)((Object)newState));
    }

    public static enum State {
        CLOSED,
        OPEN,
        ACTIVE;

        private static final State[] STATES;
        public static final MyCodec<State> CODEC;

        static {
            STATES = State.values();
            CODEC = MyCodecs.INTEGER.xmap(i -> STATES[i], Enum::ordinal);
        }
    }
}

