/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.components;

import blusunrize.immersiveengineering.api.IETags;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.ItemWithKeyID;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class KeySwitch
extends PanelComponentType<BusSignalRef, State> {
    public static final Vec2d SIZE = new Vec2d(1.0, 1.0);
    public static final double HEIGHT = 0.5;

    public KeySwitch() {
        super(BusSignalRef.DEFAULT, new State(BaseState.EMPTY, new UUID(0L, 0L)), BusSignalRef.CODEC, State.CODEC, SIZE, 0.0);
    }

    @Override
    public Pair<InteractionResult, State> click(BusSignalRef outSignal, State oldState, PanelComponentType.ComponentClickContext ctx) {
        ItemStack heldStack = ctx.getHeldItem();
        switch (oldState.baseState) {
            case EMPTY: {
                if (!heldStack.m_150930_((Item)CEItems.LOCK.get())) break;
                State newState = new State(BaseState.KEY_INSERTED, ItemWithKeyID.getUUID(heldStack));
                heldStack.m_41774_(1);
                return KeySwitch.success(newState);
            }
            case HAS_LOCK: {
                if (!heldStack.m_150930_((Item)CEItems.KEY.get()) || !oldState.lockId().equals(ItemWithKeyID.getUUID(heldStack))) break;
                heldStack.m_41774_(1);
                return KeySwitch.success(oldState.with(BaseState.KEY_INSERTED));
            }
            case KEY_INSERTED: {
                if (ctx.player() == null || !ctx.isSneaking()) {
                    return KeySwitch.success(oldState.with(BaseState.KEY_TURNED));
                }
                if (heldStack.m_204117_(IETags.screwdrivers)) {
                    ItemUtil.giveOrDrop(ctx.player(), ItemWithKeyID.create(CEItems.LOCK, oldState.lockId));
                    return KeySwitch.success(oldState.with(BaseState.EMPTY));
                }
                ItemUtil.giveOrDrop(ctx.player(), ItemWithKeyID.create(CEItems.KEY, oldState.lockId));
                return KeySwitch.success(oldState.with(BaseState.HAS_LOCK));
            }
            case KEY_TURNED: {
                return KeySwitch.success(oldState.with(BaseState.KEY_INSERTED));
            }
        }
        return KeySwitch.pass(oldState);
    }

    @Override
    public BusState getEmittedState(BusSignalRef busSignalRef, State state) {
        if (state.baseState() == BaseState.KEY_TURNED) {
            return BusState.EMPTY.with(busSignalRef, 255);
        }
        return BusState.EMPTY;
    }

    @Override
    @Nullable
    public AABB getSelectionShape(State state) {
        if (state.baseState() == BaseState.EMPTY) {
            return new AABB(0.0, 0.0, 0.0, SIZE.x(), 0.001, SIZE.y());
        }
        return new AABB(0.0, 0.0, 0.0, SIZE.x(), 0.5, SIZE.y());
    }

    public record State(BaseState baseState, UUID lockId) {
        public static final MyCodec<State> CODEC = new RecordCodec2<State, BaseState, UUID>(new CodecField<State, BaseState>("baseState", State::baseState, BaseState.CODEC), new CodecField<State, UUID>("lockId", State::lockId, MyCodecs.UUID_CODEC), State::new);

        public State with(BaseState newBaseState) {
            return new State(newBaseState, this.lockId());
        }
    }

    public static enum BaseState {
        EMPTY,
        HAS_LOCK,
        KEY_INSERTED,
        KEY_TURNED;

        public static final MyCodec<BaseState> CODEC;

        static {
            CODEC = MyCodecs.forEnum((Enum[])BaseState.values(), Enum::ordinal);
        }
    }
}

