/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.components;

import com.mojang.datafixers.util.Pair;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;

public class Slider
extends PanelComponentType<ColorAndSignal, Integer> {
    public static final double KNOB_SIZE = 1.0;
    public static final double LENGTH = 8.0;
    private static final Vec2d SIZE_VERT = new Vec2d(1.0, 8.0);
    private static final Vec2d SIZE_HOR = new Vec2d(8.0, 1.0);
    public static final double KNOB_HEIGHT = 0.5;
    public static final double MIN_CENTER = 7.5;
    public static final double MAX_CENTER = 0.5;
    private final boolean horizontal;

    public Slider(boolean horizontal) {
        super(ColorAndSignal.DEFAULT, 0, ColorAndSignal.CODEC, MyCodecs.INTEGER, Slider.getSize(horizontal), 0.5);
        this.horizontal = horizontal;
    }

    @Override
    public Pair<InteractionResult, Integer> click(ColorAndSignal config, Integer oldState, PanelComponentType.ComponentClickContext ctx) {
        double hitCoord = this.horizontal ? 8.0 - ctx.relativeHit().f_82479_ : ctx.relativeHit().f_82481_;
        double relativeStrength = Mth.m_14008_((double)Mth.m_14112_((double)hitCoord, (double)7.5, (double)0.5), (double)0.0, (double)1.0);
        int strength = (int)Math.round(relativeStrength * 255.0);
        return Pair.of((Object)InteractionResult.SUCCESS, (Object)strength);
    }

    @Override
    public BusState getEmittedState(ColorAndSignal config, Integer strength) {
        return config.signal().singleSignalState(strength);
    }

    public static Vec2d getSize(boolean horizontal) {
        return horizontal ? SIZE_HOR : SIZE_VERT;
    }
}

