/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.components;

import com.mojang.datafixers.util.Pair;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.components.Button;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.world.InteractionResult;

public class TimedButton
extends PanelComponentType<ColorAndSignal, Integer> {
    private static final int DELAY = 20;

    public TimedButton() {
        super(ColorAndSignal.DEFAULT, 0, ColorAndSignal.CODEC, MyCodecs.INTEGER, Button.SIZE, 0.5);
    }

    @Override
    public BusState getEmittedState(ColorAndSignal config, Integer remainingOn) {
        if (TimedButton.isActive(remainingOn)) {
            return config.signal().singleSignalState(255);
        }
        return BusState.EMPTY;
    }

    @Override
    public Integer tick(ColorAndSignal config, Integer remainingOn) {
        return remainingOn > 0 ? remainingOn - 1 : 0;
    }

    @Override
    public Pair<InteractionResult, Integer> click(ColorAndSignal config, Integer remainingOn, PanelComponentType.ComponentClickContext ctx) {
        if (TimedButton.isActive(remainingOn)) {
            return Pair.of((Object)InteractionResult.PASS, (Object)remainingOn);
        }
        return Pair.of((Object)InteractionResult.SUCCESS, (Object)20);
    }

    @Override
    public boolean canClientDistinguish(Integer stateA, Integer stateB) {
        return TimedButton.isActive(stateA) != TimedButton.isActive(stateB);
    }

    public static boolean isActive(Integer state) {
        return state > 0;
    }
}

