/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.components;

import com.mojang.datafixers.util.Pair;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;

public class Variac
extends PanelComponentType<BusSignalRef, Integer> {
    public static final Vec2d SIZE = new Vec2d(4.0, 4.0);
    public static final float ANGLE_MAX = -2.8274336f;
    public static final float ANGLE_MIN = 2.8274336f;

    public Variac() {
        super(BusSignalRef.DEFAULT, 0, BusSignalRef.CODEC, MyCodecs.INTEGER, SIZE, 2.0);
    }

    @Override
    public Pair<InteractionResult, Integer> click(BusSignalRef line, Integer oldState, PanelComponentType.ComponentClickContext ctx) {
        double yRelativeCenter;
        double xRelativeCenter = ctx.relativeHit().f_82479_ - SIZE.x() / 2.0;
        double angle = Math.atan2(-xRelativeCenter, -(yRelativeCenter = ctx.relativeHit().f_82481_ - SIZE.y() / 2.0));
        int target = Mth.m_14045_((int)Variac.getStrengthForRotation(angle), (int)0, (int)255);
        if (target == oldState) {
            return Pair.of((Object)InteractionResult.PASS, (Object)oldState);
        }
        if (!ctx.isSneaking()) {
            return Pair.of((Object)InteractionResult.SUCCESS, (Object)target);
        }
        if (target < oldState) {
            return Pair.of((Object)InteractionResult.SUCCESS, (Object)(oldState - 1));
        }
        return Pair.of((Object)InteractionResult.SUCCESS, (Object)(oldState + 1));
    }

    @Override
    public BusState getEmittedState(BusSignalRef line, Integer strength) {
        return line.singleSignalState(strength);
    }

    public static float getRotationForStrength(int strength) {
        float relative = (float)strength / 255.0f;
        return Mth.m_14179_((float)relative, (float)2.8274336f, (float)-2.8274336f);
    }

    public static int getStrengthForRotation(double rotation) {
        float relative = (float)Mth.m_14112_((double)rotation, (double)2.8274335861206055, (double)-2.8274335861206055);
        return (int)(relative * 255.0f);
    }
}

