/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.util.ColorUtils;
import malte0811.controlengineering.util.DirectionUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class ButtonRender<S>
implements ComponentRenderer<ColorAndSignal, S> {
    private static final Vec3 BOX_MIN = Vec3.f_82478_;
    private static final Vec3 BOX_MAX = new Vec3(1.0, 0.5, 1.0);
    private static final Map<Direction, RenderType> TARGETS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)MixedModel.SOLID_STATIC).put((Object)Direction.EAST, (Object)MixedModel.SOLID_STATIC).put((Object)Direction.SOUTH, (Object)MixedModel.SOLID_STATIC).put((Object)Direction.WEST, (Object)MixedModel.SOLID_STATIC).put((Object)Direction.UP, (Object)MixedModel.SOLID_DYNAMIC).build();
    private final Predicate<S> active;

    public ButtonRender(Predicate<S> active) {
        this.active = active;
    }

    @Override
    public void render(MixedModel output, ColorAndSignal config, S state, PoseStack transform) {
        ImmutableMap lightOverrides;
        EnumMap<Direction, Integer> colors = new EnumMap<Direction, Integer>(Direction.class);
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            colors.put(d, -1);
        }
        if (this.active.test(state)) {
            lightOverrides = ImmutableMap.of((Object)Direction.UP, (Object)15);
            colors.put(Direction.UP, config.color());
        } else {
            lightOverrides = ImmutableMap.of();
            colors.put(Direction.UP, ColorUtils.halfColor(config.color()));
        }
        RenderUtils.renderColoredBox(output, transform, BOX_MIN, BOX_MAX, colors, (Map<Direction, Integer>)lightOverrides, TARGETS);
    }
}

