/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.components.TimedButton;
import malte0811.controlengineering.controlpanels.renders.ButtonRender;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.controlpanels.renders.CoveredSwitchRender;
import malte0811.controlengineering.controlpanels.renders.IndicatorRender;
import malte0811.controlengineering.controlpanels.renders.KeySwitchRender;
import malte0811.controlengineering.controlpanels.renders.LabelRender;
import malte0811.controlengineering.controlpanels.renders.PanelMeterRender;
import malte0811.controlengineering.controlpanels.renders.SliderRender;
import malte0811.controlengineering.controlpanels.renders.SwitchRender;
import malte0811.controlengineering.controlpanels.renders.VariacRender;
import net.minecraft.client.renderer.RenderType;

public class ComponentRenderers {
    private static final Map<PanelComponentType<?, ?>, ComponentRenderer<?, ?>> RENDERS = new HashMap();

    public static void init() {
        ComponentRenderers.register(PanelComponents.BUTTON, new ButtonRender<Boolean>(b -> b));
        ComponentRenderers.register(PanelComponents.INDICATOR, new IndicatorRender());
        ComponentRenderers.register(PanelComponents.LABEL, new LabelRender());
        ComponentRenderers.register(PanelComponents.TOGGLE_SWITCH, new SwitchRender());
        ComponentRenderers.register(PanelComponents.COVERED_SWITCH, new CoveredSwitchRender());
        ComponentRenderers.register(PanelComponents.TIMED_BUTTON, new ButtonRender<Integer>(TimedButton::isActive));
        ComponentRenderers.register(PanelComponents.PANEL_METER, new PanelMeterRender());
        ComponentRenderers.register(PanelComponents.VARIAC, new VariacRender());
        ComponentRenderers.register(PanelComponents.SLIDER_HOR, new SliderRender(true));
        ComponentRenderers.register(PanelComponents.SLIDER_VERT, new SliderRender(false));
        ComponentRenderers.register(PanelComponents.KEY_SWITCH, new KeySwitchRender());
    }

    public static <Config, State> void register(PanelComponentType<Config, State> type, ComponentRenderer<Config, State> renderer) {
        RENDERS.put(type, renderer);
    }

    public static <Config, State> ComponentRenderer<Config, State> getRenderer(PanelComponentType<Config, State> type) {
        return RENDERS.get(type);
    }

    public static MixedModel renderAll(List<PlacedComponent> components, PoseStack transform, RenderType ... staticTypes) {
        MixedModel result = new MixedModel(staticTypes);
        for (PlacedComponent component : components) {
            transform.m_85836_();
            transform.m_85837_(component.getPosMin().x(), 0.0, component.getPosMin().y());
            ComponentRenderers.render(result, component.getComponent(), transform);
            transform.m_85849_();
        }
        return result;
    }

    public static <Config, State> void render(MixedModel out, PanelComponentInstance<Config, State> instance, PoseStack transform) {
        ComponentRenderers.getRenderer((PanelComponentType)instance.getType()).render(out, instance.getConfig(), instance.getState(), transform);
    }
}

