/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.components.CoveredToggleSwitch;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderers;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CoveredSwitchRender
implements ComponentRenderer<ColorAndSignal, CoveredToggleSwitch.State> {
    private static final Vec3 SIZE = (Vec3)Util.m_137537_(() -> {
        AABB shape = Objects.requireNonNull(((PanelComponentInstance)PanelComponents.COVERED_SWITCH.newInstance()).getSelectionShape());
        return new Vec3(shape.f_82291_, shape.f_82292_, shape.f_82293_);
    });
    private static final Quaternion OPEN_ROTATION = new Quaternion(-60.0f, 0.0f, 0.0f, true);

    @Override
    public void render(MixedModel output, ColorAndSignal config, CoveredToggleSwitch.State state, PoseStack transform) {
        ComponentRenderer<BusSignalRef, Boolean> switchRender = ComponentRenderers.getRenderer(PanelComponents.TOGGLE_SWITCH);
        switchRender.render(output, config.signal(), state == CoveredToggleSwitch.State.ACTIVE, transform);
        if (state != CoveredToggleSwitch.State.CLOSED) {
            transform.m_85836_();
            transform.m_85845_(OPEN_ROTATION);
        }
        EnumMap<Direction, Integer> colors = new EnumMap<Direction, Integer>(Direction.class);
        colors.put(Direction.NORTH, config.color());
        colors.put(Direction.UP, config.color());
        colors.put(Direction.EAST, config.color());
        colors.put(Direction.WEST, config.color());
        RenderUtils.renderColoredBox(output, transform, Vec3.f_82478_, SIZE, colors, Map.of(), RenderUtils.ALL_DYNAMIC);
        RenderUtils.renderColoredBox(output, transform, Vec3.f_82478_, SIZE, colors, Map.of(), RenderUtils.ALL_DYNAMIC, true);
        if (state != CoveredToggleSwitch.State.CLOSED) {
            transform.m_85849_();
        }
    }
}

