/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.Map;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.controlpanels.components.KeySwitch;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class KeySwitchRender
implements ComponentRenderer<BusSignalRef, KeySwitch.State> {
    private static final int BOX_COLOR = 0xAAAAAA;
    private static final int HOLE_COLOR = 0x222222;
    private static final int KEY_COLOR = 0xCCCCCC;
    private static final double SLOT_WIDTH = 0.125;
    private static final double SLOT_HEIGHT = 0.625;
    private static final double KEY_BASE_Y = 0.25;
    private static final Map<Direction, Integer> BOX_COLORS = RenderUtils.makeColorsExcept(0xAAAAAA, Direction.DOWN);
    private static final Map<Direction, Integer> KEY_BASE_COLORS = RenderUtils.makeColorsExcept(0xCCCCCC, Direction.DOWN, Direction.UP);
    private static final Map<Direction, Integer> KEY_HANDLE_COLORS = RenderUtils.makeColorsExcept(0, new Direction[0]);
    private static final Quaternion TURN_KEY = new Quaternion(0.0f, 90.0f, 0.0f, true);

    @Override
    public void render(MixedModel output, BusSignalRef busSignalRef, KeySwitch.State state, PoseStack transform) {
        ComponentRenderer.renderBase(output, transform, KeySwitch.SIZE, 0x222222);
        if (state.baseState() == KeySwitch.BaseState.EMPTY) {
            return;
        }
        RenderUtils.renderColoredBox(output, transform, Vec3.f_82478_, KeySwitch.SIZE.withHeight(0.5), BOX_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
        transform.m_85836_();
        transform.m_85837_(0.0, 0.5, 0.0);
        if (state.baseState() == KeySwitch.BaseState.KEY_TURNED) {
            transform.m_85837_(KeySwitch.SIZE.x() / 2.0, 0.0, KeySwitch.SIZE.y() / 2.0);
            transform.m_85845_(TURN_KEY);
            transform.m_85837_(-KeySwitch.SIZE.x() / 2.0, 0.0, -KeySwitch.SIZE.y() / 2.0);
        }
        output.setSpriteForStaticTargets(QuadBuilder.getWhiteTexture());
        transform.m_85837_(0.5, 0.0, 0.5);
        TransformingVertexBuilder transformed = new TransformingVertexBuilder(output, MixedModel.SOLID_DYNAMIC, transform);
        new QuadBuilder(new Vec3(-0.0625, 0.01, 0.3125), new Vec3(0.0625, 0.01, 0.3125), new Vec3(0.0625, 0.01, -0.3125), new Vec3(-0.0625, 0.01, -0.3125)).setRGB(0x222222).writeTo(transformed);
        if (state.baseState() != KeySwitch.BaseState.HAS_LOCK) {
            RenderUtils.renderColoredBox(output, transform, new Vec3(-0.0625, 0.0, -0.25), new Vec3(0.0625, 0.25, 0.25), KEY_BASE_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
            RenderUtils.renderColoredBox(output, transform, new Vec3(-0.125, 0.25, -0.4), new Vec3(0.125, 1.05, 0.4), KEY_HANDLE_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
        }
        transform.m_85849_();
    }
}

