/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.controlpanels.components.PanelMeter;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;

public class PanelMeterRender
implements ComponentRenderer<BusSignalRef, Integer> {
    private static final List<Marker> MARKERS = (List)Util.m_137469_(new ArrayList(), list -> {
        for (int i = 0; i < 4; ++i) {
            int strength = i * 255 / 3;
            list.add(new Marker(Integer.toString(strength), PanelMeterRender.rotationFor(strength)));
        }
    });
    private static final Quaternion MARKER_FONT_ROTATION = (Quaternion)Util.m_137537_(() -> {
        Quaternion result = new Quaternion(0.0f, (float)Math.PI, 0.0f, false);
        result.m_80148_(new Quaternion(1.5707964f, 0.0f, 0.0f, false));
        return result;
    });
    private static final double AXIS_X = PanelMeter.SIZE.x() / 2.0;
    private static final double AXIS_Y = PanelMeter.SIZE.y() / 6.0;
    private static final double NEEDLE_LENGTH = PanelMeter.SIZE.y() - 2.0 * AXIS_Y;
    private static final double NEEDLE_WIDTH = NEEDLE_LENGTH / 10.0;

    @Override
    public void render(MixedModel output, BusSignalRef line, Integer strength, PoseStack transform) {
        ComponentRenderer.renderBase(output, transform, PanelMeter.SIZE, -1);
        transform.m_85836_();
        transform.m_85837_(AXIS_X, 0.02, PanelMeter.SIZE.y() - AXIS_Y);
        this.renderMarkers(output, transform);
        this.renderNeedle(output, transform, strength);
        transform.m_85849_();
    }

    private void renderMarkers(MixedModel output, PoseStack transform) {
        Font font = Minecraft.m_91087_().f_91062_;
        for (Marker marker : MARKERS) {
            transform.m_85836_();
            transform.m_85845_(marker.angle());
            transform.m_85837_(0.0, 0.0, NEEDLE_LENGTH);
            transform.m_85845_(MARKER_FONT_ROTATION);
            float scale = 0.0625f;
            transform.m_85841_(0.0625f, 0.0625f, 0.0625f);
            String string = marker.desc();
            float f = (float)(-font.m_92895_(marker.desc())) / 2.0f;
            Objects.requireNonNull(font);
            font.m_92811_(string, f, (float)(-9) / 2.0f, 0, false, transform.m_85850_().m_85861_(), (MultiBufferSource)output, false, 0, 0);
            transform.m_85849_();
        }
    }

    private void renderNeedle(MixedModel output, PoseStack transform, int strength) {
        transform.m_85845_(PanelMeterRender.rotationFor(strength));
        new QuadBuilder(new Vec3(-NEEDLE_WIDTH / 2.0, 0.0, NEEDLE_LENGTH), new Vec3(NEEDLE_WIDTH / 2.0, 0.0, NEEDLE_LENGTH), new Vec3(NEEDLE_WIDTH / 2.0, 0.0, 0.0), new Vec3(-NEEDLE_WIDTH / 2.0, 0.0, 0.0)).setRGB(0).writeTo(new TransformingVertexBuilder(output, MixedModel.SOLID_DYNAMIC, transform));
    }

    private static Quaternion rotationFor(int signalStrength) {
        float relative = (float)signalStrength / 255.0f;
        float totalAngle = 2.0943952f;
        float angleFromVertical = (relative - 0.5f) * totalAngle;
        return new Quaternion(0.0f, (float)Math.PI - angleFromVertical, 0.0f, false);
    }

    private record Marker(String desc, Quaternion angle) {
    }
}

