/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.Map;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.controlpanels.components.Slider;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.controlpanels.renders.IndicatorRender;
import malte0811.controlengineering.util.DirectionUtils;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class SliderRender
implements ComponentRenderer<ColorAndSignal, Integer> {
    private static final Vec3 KNOB_MAX = new Vec3(1.0, 0.5, 1.0);
    private final boolean horizontal;

    public SliderRender(boolean horizontal) {
        this.horizontal = horizontal;
    }

    @Override
    public void render(MixedModel output, ColorAndSignal config, Integer strength, PoseStack transform) {
        ComponentRenderer.renderBase(output, transform, Slider.getSize(this.horizontal), 0x808080);
        double knobCenter = Mth.m_14139_((double)((double)strength.intValue() / 255.0), (double)7.5, (double)0.5);
        transform.m_85836_();
        if (this.horizontal) {
            transform.m_85837_(8.0 - knobCenter - 0.5, 0.0, 0.0);
        } else {
            transform.m_85837_(0.0, 0.0, knobCenter - 0.5);
        }
        EnumMap<Direction, Integer> colors = new EnumMap<Direction, Integer>(Direction.class);
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            colors.put(d, -1);
        }
        Map<Direction, Integer> lightOverrides = Map.of(Direction.UP, IndicatorRender.lightForStrength(strength));
        colors.put(Direction.UP, IndicatorRender.colorForStrength(config.color(), strength));
        RenderUtils.renderColoredBox(output, transform, Vec3.f_82478_, KNOB_MAX, colors, lightOverrides, RenderUtils.ALL_DYNAMIC);
        transform.m_85849_();
    }
}

