/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.EnumMap;
import java.util.Map;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.controlpanels.components.ToggleSwitch;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.util.DirectionUtils;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class SwitchRender
implements ComponentRenderer<BusSignalRef, Boolean> {
    private static final int BASE_COLOR = 0xD0D0D0;
    private static final int ROD_COLOR = 0xA0A0A0;
    private static final Quaternion ROTATION_OFF = new Quaternion(30.0f, 0.0f, 0.0f, true);
    private static final Quaternion ROTATION_ON = new Quaternion(-30.0f, 0.0f, 0.0f, true);
    private static final Map<Direction, Integer> SIDE_COLORS = (Map)Util.m_137469_(new EnumMap(Direction.class), sideColors -> {
        for (Direction side : DirectionUtils.VALUES) {
            if (side == Direction.DOWN) continue;
            sideColors.put(side, 0xA0A0A0);
        }
    });
    private static final float ROD_DIAMETER = 0.5f;

    @Override
    public void render(MixedModel output, BusSignalRef state, Boolean active, PoseStack transform) {
        output.setSpriteForStaticTargets(QuadBuilder.getWhiteTexture());
        ComponentRenderer.renderBase(output, transform, ToggleSwitch.SIZE, 0xD0D0D0);
        transform.m_85836_();
        transform.m_85837_((ToggleSwitch.SIZE.x() - 0.5) / 2.0, 0.0, (ToggleSwitch.SIZE.y() - 0.5) / 2.0);
        transform.m_85845_(active != false ? ROTATION_ON : ROTATION_OFF);
        RenderUtils.renderColoredBox(output, transform, new Vec3(0.0, -0.1, 0.0), new Vec3(0.5, 1.5, 0.5), SIDE_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
        transform.m_85849_();
    }
}

