/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.controlpanels.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.EnumMap;
import java.util.Map;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.target.RenderUtils;
import malte0811.controlengineering.client.render.utils.TransformingVertexBuilder;
import malte0811.controlengineering.controlpanels.components.Variac;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderer;
import malte0811.controlengineering.util.DirectionUtils;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class VariacRender
implements ComponentRenderer<BusSignalRef, Integer> {
    private static final Map<Direction, Integer> BASE_COLORS = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        int baseColor = 0xF0F0F0;
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            map.put(d, 0xF0F0F0);
        }
    });
    private static final Map<Direction, Integer> KNOB_COLORS = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        int baseColor = 0x202020;
        for (Direction d : DirectionUtils.VALUES) {
            map.put(d, 0x202020);
        }
    });
    private static final double ROD_RADIUS = 0.5;
    private static final double ROD_LENGTH = 1.0;
    private static final double KNOB_RADIUS = Variac.SIZE.x() / (double)(2.0f * Mth.f_13994_);
    private static final double KNOB_HEIGHT = 1.0;
    private static final double MAX_Y = 2.0;
    private static final Vec3 ROD_MIN = new Vec3(-0.5, 0.0, -0.5);
    private static final Vec3 ROD_MAX = new Vec3(0.5, 1.0, 0.5);
    private static final Vec3 KNOB_MIN = new Vec3(-KNOB_RADIUS, 1.0, -KNOB_RADIUS);
    private static final Vec3 KNOB_MAX = new Vec3(KNOB_RADIUS, 2.0, KNOB_RADIUS);
    private static final Quaternion ONE_EIGHTH = new Quaternion(0.0f, 0.7853982f, 0.0f, false);

    @Override
    public void render(MixedModel output, BusSignalRef busSignalRef, Integer strength, PoseStack transform) {
        transform.m_85836_();
        transform.m_85837_(Variac.SIZE.x() / 2.0, 0.0, Variac.SIZE.y() / 2.0);
        RenderUtils.renderColoredBox(output, transform, ROD_MIN, ROD_MAX, BASE_COLORS, Map.of(), RenderUtils.ALL_STATIC);
        transform.m_85845_(VariacRender.getRotation(strength));
        RenderUtils.renderColoredBox(output, transform, KNOB_MIN, KNOB_MAX, KNOB_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
        transform.m_85836_();
        transform.m_85845_(ONE_EIGHTH);
        RenderUtils.renderColoredBox(output, transform, KNOB_MIN, KNOB_MAX, KNOB_COLORS, Map.of(), RenderUtils.ALL_DYNAMIC);
        transform.m_85849_();
        new QuadBuilder(new Vec3(0.0, 2.01, -Variac.SIZE.y() / 2.0), new Vec3(0.0, 2.01, -Variac.SIZE.y() / 2.0), new Vec3(-0.2, 2.01, -Variac.SIZE.y() / 2.0 + 0.4), new Vec3(0.2, 2.01, -Variac.SIZE.y() / 2.0 + 0.4)).setRGB(-1).writeTo(new TransformingVertexBuilder(output, MixedModel.SOLID_DYNAMIC, transform));
        transform.m_85849_();
    }

    private static Quaternion getRotation(int strength) {
        return new Quaternion(0.0f, Variac.getRotationForStrength(strength), 0.0f, false);
    }
}

