/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting;

import java.util.Arrays;
import javax.annotation.Nonnull;
import malte0811.controlengineering.crafting.CERecipeSerializers;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.PunchedTapeItem;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;

public record GlueTapeRecipe(ResourceLocation id, Ingredient glue) implements CraftingRecipe,
IShapedRecipe<CraftingContainer>
{
    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.findMatch(inv) >= 0;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        int match = this.findMatch(inv);
        if (match < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack tape1 = inv.m_8020_(match);
        ItemStack tape2 = inv.m_8020_(match + 2);
        byte[] first = PunchedTapeItem.getBytes(tape1);
        byte[] second = PunchedTapeItem.getBytes(tape2);
        byte[] combined = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, combined, first.length, second.length);
        return PunchedTapeItem.withBytes(combined);
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 1;
    }

    private int findMatch(CraftingContainer inv) {
        for (int x = 0; x < inv.m_39347_() - 2; ++x) {
            for (int y = 0; y < inv.m_39346_(); ++y) {
                int offset = y * inv.m_39347_() + x;
                ItemStack tape1 = inv.m_8020_(offset);
                ItemStack glue = inv.m_8020_(offset + 1);
                ItemStack tape2 = inv.m_8020_(offset + 2);
                if (!tape1.m_150930_((Item)CEItems.PUNCHED_TAPE.get()) || !this.glue.test(glue) || !tape2.m_150930_((Item)CEItems.PUNCHED_TAPE.get())) continue;
                int totalLength = PunchedTapeItem.getBytes(tape1).length + PunchedTapeItem.getBytes(tape2).length;
                if (totalLength > 10000) {
                    return -1;
                }
                return offset;
            }
        }
        return -1;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ((PunchedTapeItem)((Object)CEItems.PUNCHED_TAPE.get())).m_7968_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CEItems.PUNCHED_TAPE.get()}), this.glue, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CEItems.PUNCHED_TAPE.get()})});
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CERecipeSerializers.GLUE_TAPE.get();
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 1;
    }
}

