/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.ItemWithKeyID;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class OptionalKeyCopyRecipe
extends ShapedRecipe {
    private final boolean isIdOptional;
    private final NonNullList<Ingredient> ingredientsWithIdSource;

    public OptionalKeyCopyRecipe(ShapedRecipe baseRecipe, boolean isIdOptional) {
        super(baseRecipe.m_6423_(), baseRecipe.m_6076_(), baseRecipe.m_44220_(), baseRecipe.m_44221_(), baseRecipe.m_7527_(), baseRecipe.m_8043_());
        Preconditions.checkArgument((boolean)(this.m_8043_().m_41720_() instanceof ItemWithKeyID));
        this.isIdOptional = isIdOptional;
        this.ingredientsWithIdSource = NonNullList.m_122779_();
        this.ingredientsWithIdSource.addAll((Collection)baseRecipe.m_7527_());
        for (int i = 0; i < this.ingredientsWithIdSource.size(); ++i) {
            if (!((Ingredient)this.ingredientsWithIdSource.get(i)).m_43947_()) continue;
            Item[] allowedItems = isIdOptional ? new Item[]{Items.f_41852_, (Item)CEItems.KEY.get(), (Item)CEItems.LOCK.get()} : new Item[]{(Item)CEItems.KEY.get(), (Item)CEItems.LOCK.get()};
            this.ingredientsWithIdSource.set(i, (Object)Ingredient.m_43938_(Arrays.stream(allowedItems).map(Item::m_7968_).map(Ingredient.ItemValue::new)));
            break;
        }
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredientsWithIdSource;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        Match idSource = this.removeIDSource(inv);
        if (!this.isIdOptional && idSource == null) {
            return false;
        }
        return super.m_5818_(idSource != null ? idSource.withoutSource : inv, level);
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inv) {
        ItemStack producedItem;
        Match match = this.removeIDSource(inv);
        if (match != null) {
            producedItem = super.m_5874_(match.withoutSource);
            ItemWithKeyID.copyIdFrom(producedItem, inv.m_8020_(match.slotId));
        } else {
            producedItem = super.m_5874_(inv);
            ItemWithKeyID.addRandomId(producedItem);
        }
        return producedItem;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        Match idSource = this.removeIDSource(container);
        NonNullList remaining = super.m_7457_((Container)container);
        if (idSource != null) {
            remaining.set(idSource.slotId, (Object)container.m_8020_(idSource.slotId).m_41777_());
        }
        return remaining;
    }

    @Nullable
    private Match removeIDSource(@Nonnull CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!(inv.m_8020_(i).m_41720_() instanceof ItemWithKeyID)) continue;
            CraftingContainer newContainer = new CraftingContainer(new AbstractContainerMenu(null, 0){

                public boolean m_6875_(@Nonnull Player player) {
                    return false;
                }
            }, inv.m_39347_(), inv.m_39346_());
            for (int j = 0; j < inv.m_6643_(); ++j) {
                if (j == i) continue;
                newContainer.m_6836_(j, inv.m_8020_(j));
            }
            return new Match(i, newContainer);
        }
        return null;
    }

    public boolean isIdOptional() {
        return this.isIdOptional;
    }

    private record Match(int slotId, CraftingContainer withoutSource) {
    }
}

