/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.crafting.OptionalKeyCopyRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class OptionalKeyCopySerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<OptionalKeyCopyRecipe> {
    public static final String IS_ID_OPTIONAL = "isIdOptional";

    @Nonnull
    public OptionalKeyCopyRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject serializedRecipe) {
        ShapedRecipe baseRecipe = (ShapedRecipe)f_44076_.m_6729_(recipeId, serializedRecipe);
        boolean isOptional = serializedRecipe.get(IS_ID_OPTIONAL).getAsBoolean();
        return new OptionalKeyCopyRecipe(baseRecipe, isOptional);
    }

    public OptionalKeyCopyRecipe fromJson(ResourceLocation recipeLoc, JsonObject recipeJson, ICondition.IContext context) {
        ShapedRecipe baseRecipe = (ShapedRecipe)f_44076_.fromJson(recipeLoc, recipeJson, context);
        boolean isOptional = recipeJson.get(IS_ID_OPTIONAL).getAsBoolean();
        return new OptionalKeyCopyRecipe(baseRecipe, isOptional);
    }

    @Nullable
    public OptionalKeyCopyRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        ShapedRecipe baseRecipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
        boolean isOptional = buffer.readBoolean();
        if (baseRecipe != null) {
            return new OptionalKeyCopyRecipe(baseRecipe, isOptional);
        }
        return null;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull OptionalKeyCopyRecipe recipe) {
        f_44076_.m_6178_(buffer, (Recipe)recipe);
        buffer.writeBoolean(recipe.isIdOptional());
    }
}

