/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.crafting.CERecipeSerializers;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.ISchematicItem;
import malte0811.controlengineering.items.SchematicItem;
import malte0811.controlengineering.logic.schematic.Schematic;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public record SchematicCopyRecipe(ResourceLocation id) implements CraftingRecipe
{
    public boolean matches(@Nonnull CraftingContainer container, @Nonnull Level level) {
        return this.getSchematicToCopy(container) != null;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer container) {
        Match schematic = this.getSchematicToCopy(container);
        if (schematic != null) {
            return ISchematicItem.create(CEItems.SCHEMATIC, schematic.toCopy());
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        NonNullList remaining = super.m_7457_((Container)container);
        Match match = this.getSchematicToCopy(container);
        if (match != null) {
            remaining.set(match.slotCopiedFrom(), (Object)container.m_8020_(match.slotCopiedFrom()).m_41777_());
        }
        return remaining;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ((SchematicItem)CEItems.SCHEMATIC.get()).m_7968_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CERecipeSerializers.SCHEMATIC_COPY.get();
    }

    @Nullable
    private Match getSchematicToCopy(CraftingContainer container) {
        boolean hasEmpty = false;
        Match matchedSource = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stackHere = container.m_8020_(i);
            if (stackHere.m_41720_() instanceof ISchematicItem) {
                Schematic schematic = ISchematicItem.getSchematic(stackHere);
                if (stackHere.m_150930_((Item)CEItems.SCHEMATIC.get()) && Schematic.isEmpty(schematic)) {
                    if (hasEmpty) {
                        return null;
                    }
                    hasEmpty = true;
                    continue;
                }
                if (matchedSource != null || Schematic.isEmpty(schematic)) {
                    return null;
                }
                matchedSource = new Match(schematic, i);
                continue;
            }
            if (stackHere.m_41619_()) continue;
            return null;
        }
        return hasEmpty ? matchedSource : null;
    }

    private record Match(Schematic toCopy, int slotCopiedFrom) {
    }
}

