/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SingleIngredientRecipeSerializer<R extends Recipe<?>>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<R> {
    private final String key;
    private final BiFunction<ResourceLocation, Ingredient, R> makeRecipe;
    private final Function<R, Ingredient> getIngredient;

    public SingleIngredientRecipeSerializer(String key, BiFunction<ResourceLocation, Ingredient, R> makeRecipe, Function<R, Ingredient> getIngredient) {
        this.key = key;
        this.makeRecipe = makeRecipe;
        this.getIngredient = getIngredient;
    }

    @Nonnull
    public R m_6729_(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Ingredient ingred = Ingredient.m_43917_((JsonElement)json.get(this.getKey()));
        return (R)((Recipe)this.makeRecipe.apply(recipeId, ingred));
    }

    @Nullable
    public R m_8005_(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Ingredient ingred = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return (R)((Recipe)this.makeRecipe.apply(recipeId, ingred));
    }

    public void m_6178_(@Nonnull FriendlyByteBuf buffer, @Nonnull R recipe) {
        this.getIngredient.apply(recipe).m_43923_(buffer);
    }

    public String getKey() {
        return this.key;
    }
}

