/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting.noncrafting;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.crafting.CERecipeSerializers;
import malte0811.controlengineering.crafting.CERecipeTypes;
import malte0811.controlengineering.crafting.noncrafting.BaseRecipe;
import malte0811.controlengineering.network.PacketUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ComponentCostRecipe
extends BaseRecipe {
    private final List<IngredientWithSize> cost;

    public ComponentCostRecipe(ResourceLocation id, List<IngredientWithSize> cost) {
        super(id, (Supplier<? extends RecipeSerializer<?>>)CERecipeSerializers.COMPONENT_COST, CERecipeTypes.COMPONENT_COST);
        this.cost = cost;
    }

    public List<IngredientWithSize> getCost() {
        return this.cost;
    }

    public static class Serializer
    extends BaseRecipe.BaseSerializer<ComponentCostRecipe> {
        public static final String COST_ARRAY_KEY = "costs";

        @Nonnull
        public ComponentCostRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ArrayList<IngredientWithSize> totalCost = new ArrayList<IngredientWithSize>();
            for (JsonElement ingredientJSON : json.getAsJsonArray(COST_ARRAY_KEY)) {
                totalCost.add(IngredientWithSize.deserialize((JsonElement)ingredientJSON));
            }
            return new ComponentCostRecipe(recipeId, totalCost);
        }

        @Nullable
        public ComponentCostRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            return new ComponentCostRecipe(recipeId, PacketUtils.readList(buffer, IngredientWithSize::read));
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ComponentCostRecipe recipe) {
            PacketUtils.writeList(buffer, recipe.getCost(), IngredientWithSize::write);
        }
    }
}

