/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.crafting.noncrafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.AbstractInt2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.crafting.CERecipeSerializers;
import malte0811.controlengineering.crafting.CERecipeTypes;
import malte0811.controlengineering.crafting.noncrafting.BaseRecipe;
import malte0811.controlengineering.network.PacketUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ServerFontRecipe
extends BaseRecipe {
    public static final ResourceLocation LOCATION = new ResourceLocation("controlengineering", "server_font_width");
    public static boolean IN_UNIT_TEST = false;
    private final Int2FloatMap widths;

    public ServerFontRecipe(ResourceLocation id, Int2FloatMap widths) {
        super(id, (Supplier<? extends RecipeSerializer<?>>)CERecipeSerializers.FONT_WIDTH, CERecipeTypes.SERVER_FONT);
        this.widths = widths;
    }

    public static float getWidth(Level level, String text) {
        if (IN_UNIT_TEST) {
            return text.length();
        }
        Recipe recipe = level.m_7465_().m_44043_(LOCATION).orElse(null);
        if (!(recipe instanceof ServerFontRecipe)) {
            return Float.POSITIVE_INFINITY;
        }
        ServerFontRecipe serverFont = (ServerFontRecipe)recipe;
        return (float)text.chars().mapToDouble(arg_0 -> ((Int2FloatMap)serverFont.widths).get(arg_0)).sum();
    }

    public static class Serializer
    extends BaseRecipe.BaseSerializer<ServerFontRecipe> {
        public static final String WIDTHS_KEY = "widths";

        @Nonnull
        public ServerFontRecipe fromJson(@Nonnull ResourceLocation recipeId, JsonObject json) {
            Int2FloatOpenHashMap widthsLocal = new Int2FloatOpenHashMap();
            for (Map.Entry entry : json.getAsJsonObject(WIDTHS_KEY).entrySet()) {
                widthsLocal.put(Integer.parseInt((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsFloat());
            }
            return new ServerFontRecipe(recipeId, (Int2FloatMap)widthsLocal);
        }

        @Nullable
        public ServerFontRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            List<Int2FloatMap.Entry> entries = PacketUtils.readList(buffer, fbb -> new AbstractInt2FloatMap.BasicEntry(fbb.m_130242_(), fbb.readFloat()));
            Int2FloatOpenHashMap map = new Int2FloatOpenHashMap(entries.size());
            for (Int2FloatMap.Entry entry : entries) {
                map.put(entry.getIntKey(), entry.getFloatValue());
            }
            return new ServerFontRecipe(recipeId, (Int2FloatMap)map);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ServerFontRecipe recipe) {
            PacketUtils.writeList(buffer, List.copyOf(recipe.widths.int2FloatEntrySet()), (entry, buf) -> buf.m_130130_(entry.getIntKey()).writeFloat(entry.getFloatValue()));
        }
    }
}

