/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.network.SimplePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="controlengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class CEContainerMenu<PacketType>
extends AbstractContainerMenu {
    private final List<ServerPlayer> listeners = new ArrayList<ServerPlayer>();
    private final Predicate<Player> isValid;
    private final Runnable setChanged;

    protected CEContainerMenu(@Nullable MenuType<?> type, int id, Predicate<Player> isValid, Runnable setChanged) {
        super(type, id);
        this.isValid = isValid;
        this.setChanged = setChanged;
    }

    protected CEContainerMenu(@Nullable MenuType<?> type, int id) {
        this(type, id, $ -> true, () -> {});
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return this.isValid.test(playerIn);
    }

    public void sendToListeningPlayers(PacketType data) {
        this.sendToListeningPlayersExcept(null, data);
    }

    public void sendToListeningPlayersExcept(@Nullable ServerPlayer excluded, PacketType data) {
        for (ServerPlayer player : this.listeners) {
            if (player == excluded) continue;
            this.sendTo(player, data);
        }
    }

    protected final void sendTo(ServerPlayer listener, PacketType packet) {
        ControlEngineering.NETWORK.sendTo((Object)this.makePacket(packet), listener.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    protected abstract SimplePacket makePacket(PacketType var1);

    protected abstract PacketType getInitialSync();

    public void markDirty() {
        this.setChanged.run();
    }

    private void addListener(ServerPlayer serverPlayer) {
        if (!this.listeners.contains(serverPlayer)) {
            if (this.listeners.isEmpty()) {
                this.onFirstOpened();
            }
            this.listeners.add(serverPlayer);
            this.sendTo(serverPlayer, this.getInitialSync());
        }
    }

    protected void onFirstOpened() {
    }

    protected void onLastClosed() {
    }

    @SubscribeEvent
    public static void openContainer(PlayerContainerEvent.Open ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (!(abstractContainerMenu instanceof CEContainerMenu)) {
            return;
        }
        CEContainerMenu ceContainer = (CEContainerMenu)abstractContainerMenu;
        Player player = ev.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ceContainer.addListener(serverPlayer);
    }

    @SubscribeEvent
    public static void closeContainer(PlayerContainerEvent.Close ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (!(abstractContainerMenu instanceof CEContainerMenu)) {
            return;
        }
        CEContainerMenu ceContainer = (CEContainerMenu)abstractContainerMenu;
        Player player = ev.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ceContainer.listeners.remove(serverPlayer);
        if (ceContainer.listeners.isEmpty()) {
            ceContainer.onLastClosed();
        }
    }
}

