/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.logic;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.controlengineering.gui.StackedScreen;
import malte0811.controlengineering.gui.widget.PageSelector;
import malte0811.controlengineering.logic.schematic.client.ClientSymbols;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import malte0811.controlengineering.logic.schematic.symbol.SymbolInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class CellSelectionScreen
extends StackedScreen {
    private static final float TEXT_SCALE = 4.0f;
    private static final int BORDER_SIZE_X = 70;
    private static final int BORDER_SIZE_Y = 30;
    private static final int BACKGROUND_COLOR = -2236963;
    private static final int SELECTED_COLOR = -8921737;
    private final Consumer<SymbolInstance<?>> select;
    private final List<SchematicSymbol<?>> symbols;
    private int xGrid;
    private int yGrid;
    private final int numCols = 4;
    private final int numRowsPerPage = 4;
    private PageSelector pageSelector;
    private SymbolInstance<?> selected;

    public CellSelectionScreen(Consumer<SymbolInstance<?>> select) {
        super((Component)new TextComponent("Cell selection"));
        this.select = select;
        this.symbols = new ArrayList(SchematicSymbols.REGISTRY.getValues());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.xGrid = (this.f_96543_ - 140) / 12;
        this.yGrid = (this.f_96544_ - 60 - 20) / 12;
        this.pageSelector = (PageSelector)this.m_142416_((GuiEventListener)new PageSelector(70, this.f_96544_ - 30 - 20, this.f_96543_ - 140, Mth.m_184652_((int)this.symbols.size(), (int)16), this.pageSelector != null ? this.pageSelector.getCurrentPage() : 0));
    }

    @Override
    protected void renderForeground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(70.0, 30.0, 0.0);
        matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
        int fontHeight = this.getTotalFontHeight();
        int index = this.getFirstIndexOnPage();
        for (int row = 0; index < this.symbols.size() && row < 4; ++row) {
            for (int col = 0; index < this.symbols.size() && col < 4; ++index, ++col) {
                SchematicSymbol<?> symbol = this.symbols.get(index);
                int xBase = col * this.xGrid;
                int yBase = row * this.yGrid;
                ClientSymbols.renderCenteredInBox((SymbolInstance)symbol.newInstance(), matrixStack, xBase, yBase + fontHeight, this.xGrid, this.yGrid - fontHeight - 1);
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)xBase + (double)this.xGrid / 2.0, (double)(yBase + 1), 0.0);
                matrixStack.m_85841_(0.25f, 0.25f, 1.0f);
                Component desc = symbol.getDefaultName();
                float offset = (float)(-this.f_96547_.m_92852_((FormattedText)desc)) / 2.0f;
                this.f_96547_.m_92889_(matrixStack, desc, offset, 0.0f, -16777216);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    protected void renderCustomBackground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderCustomBackground(matrixStack, mouseX, mouseY, partialTicks);
        int borderRenderSize = 5;
        CellSelectionScreen.m_93172_((PoseStack)matrixStack, (int)65, (int)25, (int)(this.f_96543_ - 70 + 5), (int)(this.f_96544_ - 30 - 20), (int)-2236963);
        matrixStack.m_85836_();
        matrixStack.m_85837_(70.0, 30.0, 0.0);
        matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
        int selected = this.getSelectedIndex(mouseX, mouseY) - this.getFirstIndexOnPage();
        if (selected >= 0) {
            int row = selected / 4;
            int col = selected % 4;
            CellSelectionScreen.m_93172_((PoseStack)matrixStack, (int)(col * this.xGrid), (int)(row * this.yGrid), (int)(col * this.xGrid + this.xGrid), (int)(row * this.yGrid + this.yGrid), (int)-8921737);
        }
        matrixStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int selected = this.getSelectedIndex(mouseX, mouseY);
        if (selected >= 0) {
            ClientSymbols.createInstanceWithUI(this.symbols.get(selected), i -> {
                this.selected = i;
            });
            return true;
        }
        return false;
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.selected != null) {
            this.select.accept(this.selected);
            this.m_7379_();
        }
    }

    private int getSelectedIndex(double mouseX, double mouseY) {
        int col = (int)((mouseX - 70.0) / (double)(this.xGrid * 3));
        int row = (int)((mouseY - 30.0) / (double)(this.yGrid * 3));
        if (col < 0 || row < 0 || col >= 4 || row >= 4) {
            return -1;
        }
        int index = row * 4 + col + this.getFirstIndexOnPage();
        if (index < this.symbols.size()) {
            return index;
        }
        return -1;
    }

    private int getFirstIndexOnPage() {
        return this.pageSelector.getCurrentPage() * 4 * 4;
    }

    private int getTotalFontHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return (int)(9.0f / 4.0f + 1.0f);
    }

    private static Level level() {
        return (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }
}

