/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.logic;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.logic.ISchematicBE;
import malte0811.controlengineering.blockentity.logic.LogicWorkbenchBlockEntity;
import malte0811.controlengineering.gui.CEContainerMenu;
import malte0811.controlengineering.gui.ContainerScreenManager;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.network.SimplePacket;
import malte0811.controlengineering.network.logic.FullSync;
import malte0811.controlengineering.network.logic.LogicPacket;
import malte0811.controlengineering.network.logic.LogicSubPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class LogicDesignMenu
extends CEContainerMenu<LogicSubPacket> {
    public final boolean readOnly;
    private final Schematic schematic;
    @Nullable
    private final LogicWorkbenchBlockEntity.AvailableIngredients availableIngredients;

    public <BE extends BlockEntity> LogicDesignMenu(MenuType<?> type, int id, BE schematicBE, boolean readOnly) {
        super(type, id, ContainerScreenManager.isValidFor(schematicBE), ((ISchematicBE)schematicBE)::setSchematicChanged);
        this.readOnly = readOnly;
        this.schematic = Objects.requireNonNull(((ISchematicBE)schematicBE).getSchematic());
        if (!readOnly) {
            LogicWorkbenchBlockEntity logicWorkbench = (LogicWorkbenchBlockEntity)schematicBE;
            this.availableIngredients = logicWorkbench.getCosts();
        } else {
            this.availableIngredients = null;
        }
        this.addSlots();
    }

    public LogicDesignMenu(MenuType<?> type, int id, Schematic schematic) {
        super(type, id, $ -> true, () -> {});
        this.readOnly = true;
        this.schematic = schematic;
        this.availableIngredients = null;
        this.addSlots();
    }

    public LogicDesignMenu(MenuType<?> type, int id, boolean readOnly) {
        super(type, id);
        this.schematic = new Schematic();
        this.readOnly = readOnly;
        this.availableIngredients = readOnly ? null : new LogicWorkbenchBlockEntity.AvailableIngredients();
        this.addSlots();
    }

    private void addSlots() {
        if (this.availableIngredients != null) {
            for (Pair<Slot, DataSlot> tracker : List.of(this.availableIngredients.makeTubeSlot(0), this.availableIngredients.makeWireSlot(1))) {
                this.m_38897_((Slot)tracker.getFirst());
                this.m_38895_((DataSlot)tracker.getSecond());
            }
        }
    }

    public static LogicDesignMenuType makeType(String name, boolean readOnly, DeferredRegister<MenuType<?>> register) {
        RegistryObject type = register.register(name, () -> {
            MutableObject typeBox = new MutableObject();
            typeBox.setValue((Object)new MenuType((arg_0, arg_1) -> LogicDesignMenu.lambda$makeType$2((Mutable)typeBox, readOnly, arg_0, arg_1)));
            return (MenuType)typeBox.getValue();
        });
        return new LogicDesignMenuType((RegistryObject<MenuType<LogicDesignMenu>>)type, readOnly);
    }

    @Nullable
    public LogicWorkbenchBlockEntity.AvailableIngredients getAvailableIngredients() {
        return this.availableIngredients;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    @Override
    protected SimplePacket makePacket(LogicSubPacket subPacket) {
        return new LogicPacket(subPacket);
    }

    @Override
    protected LogicSubPacket getInitialSync() {
        return new FullSync(this.getSchematic());
    }

    private static /* synthetic */ LogicDesignMenu lambda$makeType$2(Mutable typeBox, boolean readOnly, int id, Inventory inv) {
        return new LogicDesignMenu((MenuType)typeBox.getValue(), id, readOnly);
    }

    public record LogicDesignMenuType(RegistryObject<MenuType<LogicDesignMenu>> type, boolean readOnly) {
        public <T extends BlockEntity> LogicDesignMenu makeNew(int id, T blockEntity) {
            return new LogicDesignMenu((MenuType)this.type.get(), id, blockEntity, this.readOnly);
        }

        public MenuType<? extends LogicDesignMenu> get() {
            return (MenuType)this.type.get();
        }
    }
}

