/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.logic;

import blusunrize.lib.manual.ManualUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.ControlEngineering;
import malte0811.controlengineering.blockentity.logic.CircuitIngredientDrawer;
import malte0811.controlengineering.blockentity.logic.LogicCabinetBlockEntity;
import malte0811.controlengineering.blockentity.logic.LogicWorkbenchBlockEntity;
import malte0811.controlengineering.gui.StackedScreen;
import malte0811.controlengineering.gui.logic.CellSelectionScreen;
import malte0811.controlengineering.gui.logic.LogicDesignMenu;
import malte0811.controlengineering.gui.misc.ConfirmScreen;
import malte0811.controlengineering.gui.misc.DataProviderScreen;
import malte0811.controlengineering.gui.widget.SmallCheckbox;
import malte0811.controlengineering.items.IEItemRefs;
import malte0811.controlengineering.logic.cells.SignalType;
import malte0811.controlengineering.logic.schematic.ConnectedPin;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicCircuitConverter;
import malte0811.controlengineering.logic.schematic.SchematicNet;
import malte0811.controlengineering.logic.schematic.WireSegment;
import malte0811.controlengineering.logic.schematic.client.ClientSymbols;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SymbolInstance;
import malte0811.controlengineering.logic.schematic.symbol.SymbolPin;
import malte0811.controlengineering.network.logic.AddSymbol;
import malte0811.controlengineering.network.logic.AddWire;
import malte0811.controlengineering.network.logic.ClearAll;
import malte0811.controlengineering.network.logic.Delete;
import malte0811.controlengineering.network.logic.LogicPacket;
import malte0811.controlengineering.network.logic.LogicSubPacket;
import malte0811.controlengineering.network.logic.ModifySymbol;
import malte0811.controlengineering.network.logic.SetName;
import malte0811.controlengineering.util.ScreenUtils;
import malte0811.controlengineering.util.TextUtil;
import malte0811.controlengineering.util.math.RectangleI;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LogicDesignScreen
extends StackedScreen
implements MenuAccess<LogicDesignMenu> {
    private static final String KEY_PREFIX = "controlengineering.logicworkbench.";
    public static final String COMPONENTS_KEY = "controlengineering.logicworkbench.components";
    public static final String COMPONENTS_TOOLTIP = "controlengineering.logicworkbench.components.tooltip";
    public static final String SET_NAME_KEY = "controlengineering.logicworkbench.setName";
    public static final String SET_NAME_TOOLTIP = "controlengineering.logicworkbench.setName.tooltip";
    public static final String SET_NAME_MESSAGE = "controlengineering.logicworkbench.setName.message";
    public static final String CLEAR_ALL_KEY = "controlengineering.logicworkbench.clearAll";
    public static final String CLEAR_ALL_TOOLTIP = "controlengineering.logicworkbench.clearAll.tooltip";
    public static final String CLEAR_ALL_MESSAGE = "controlengineering.logicworkbench.clearAll.warning";
    public static final String DRC_INFO_KEY = "controlengineering.logicworkbench.drcOn";
    public static final String DIGITAL_PIN_KEY = "controlengineering.logicworkbench.digitalPin";
    public static final String ANALOG_PIN_KEY = "controlengineering.logicworkbench.analogPin";
    private static final int TRANSLUCENT_BORDER_SIZE = 20;
    private static final int WHITE_BORDER_SIZE = 1;
    private static final int TOTAL_BORDER = 21;
    public static final int BASE_SCALE = 3;
    private final LogicDesignMenu container;
    private Schematic schematic;
    @Nullable
    private Vec2i currentWireStart = null;
    @Nullable
    private PlacingSymbol placingSymbol = null;
    private boolean resetAfterPlacingSymbol = false;
    private List<ConnectedPin> errors = ImmutableList.of();
    private boolean errorsShown = false;
    private float minScale = 0.5f;
    private float currentScale = 3.0f;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double mouseXDown;
    private double mouseYDown;
    private boolean clickWasConsumed = true;

    public LogicDesignScreen(LogicDesignMenu container, Component title) {
        super(title);
        this.schematic = new Schematic();
        this.container = container;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.container.readOnly) {
            this.m_142416_((GuiEventListener)new Button(21, 21, 40, 20, (Component)new TranslatableComponent(COMPONENTS_KEY), btn -> this.f_96541_.m_91152_((Screen)new CellSelectionScreen(s -> {
                this.placingSymbol = new PlacingSymbol((SymbolInstance<?>)s, Vec2d.ZERO);
                this.resetAfterPlacingSymbol = false;
            })), this.makeTooltip(COMPONENTS_TOOLTIP)));
            this.m_142416_((GuiEventListener)new Button(21, 41, 40, 20, (Component)new TranslatableComponent(SET_NAME_KEY), this::handleSetName, this.makeTooltip(SET_NAME_TOOLTIP)));
            this.m_142416_((GuiEventListener)new Button(21, 61, 40, 20, (Component)new TranslatableComponent(CLEAR_ALL_KEY), this::handleClearAll, this.makeTooltip(CLEAR_ALL_TOOLTIP)));
            this.m_142416_((GuiEventListener)new SmallCheckbox(21, 81, 20, 20, (Component)new TextComponent("DRC"), this.errorsShown, newState -> {
                this.errorsShown = newState;
                this.updateErrors();
            }, this.makeTooltip(DRC_INFO_KEY)));
        }
        this.minScale = Math.max(LogicDesignScreen.getScaleForShownSize(this.f_96543_, Schematic.BOUNDARY.getWidth()), LogicDesignScreen.getScaleForShownSize(this.f_96544_, Schematic.BOUNDARY.getHeight()));
    }

    private void handleSetName(Button $) {
        Minecraft.m_91087_().m_91152_(DataProviderScreen.makeFor((Component)new TranslatableComponent(SET_NAME_MESSAGE), this.schematic.getName(), MyCodecs.STRING, s -> this.runAndSendToServer(new SetName((String)s))));
    }

    private void handleClearAll(Button $) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen((Component)new TranslatableComponent(CLEAR_ALL_MESSAGE), () -> this.runAndSendToServer(new ClearAll())));
    }

    private Button.OnTooltip makeTooltip(String key) {
        return ($, transform, x, y) -> this.m_96602_(transform, (Component)new TranslatableComponent(key), x, y);
    }

    @Override
    protected void renderForeground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        LogicDesignScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)this.schematic.getName(), (int)(this.f_96543_ / 2), (int)10, (int)-1);
        matrixStack.m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 0.0);
        matrixStack.m_85841_(this.currentScale, this.currentScale, 1.0f);
        matrixStack.m_85837_(-this.centerX, -this.centerY, 0.0);
        double scale = this.f_96541_.m_91268_().m_85449_();
        RenderSystem.m_69488_((int)((int)(21.0 * scale)), (int)((int)(21.0 * scale)), (int)((int)((double)(this.f_96543_ - 42) * scale)), (int)((int)((double)(this.f_96544_ - 42) * scale)));
        this.drawErrors(matrixStack);
        this.drawBoundary(matrixStack);
        Vec2d mousePos = this.getMousePosition(mouseX, mouseY);
        ClientSymbols.render(this.schematic, matrixStack, mousePos);
        Optional<Object> currentError = Optional.empty();
        PlacedSymbol placed = this.getPlacingSymbol(mousePos);
        if (placed != null) {
            currentError = this.schematic.makeChecker((Level)this.f_96541_.f_91073_).getErrorForAdding(placed);
            ClientSymbols.render(placed, matrixStack);
        } else {
            WireSegment placedWire = this.getPlacingSegment(mousePos);
            if (placedWire != null) {
                currentError = this.schematic.makeChecker((Level)this.f_96541_.f_91073_).getErrorForAdding(placedWire);
                int color = currentError.isPresent() ? -43755 : -8891115;
                placedWire.renderWithoutBlobs(matrixStack, color);
            }
        }
        RenderSystem.m_69471_();
        matrixStack.m_85849_();
        this.renderIngredients(matrixStack);
        this.renderTooltip(matrixStack, mouseX, mouseY, mousePos, currentError.orElse(null));
    }

    private void renderTooltip(PoseStack transform, int mouseX, int mouseY, Vec2d schematicMouse, @Nullable Component currentError) {
        if (currentError != null) {
            if (currentError instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)currentError;
                mutable.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
            }
            this.m_96602_(transform, currentError, mouseX, mouseY);
        } else {
            PlacedSymbol hovered = this.schematic.getSymbolAt(schematicMouse, (Level)this.f_96541_.f_91073_);
            if (hovered != null) {
                Component toShow = hovered.symbol().getName();
                ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
                tooltip.add(toShow.m_7532_());
                for (SymbolPin pin : this.getHoveredPins(hovered, schematicMouse)) {
                    String key = pin.type() == SignalType.DIGITAL ? DIGITAL_PIN_KEY : ANALOG_PIN_KEY;
                    tooltip.add(new TranslatableComponent(key, new Object[]{pin.pinName()}).m_130940_(ChatFormatting.GRAY).m_7532_());
                }
                List<MutableComponent> extra = hovered.symbol().getExtraDesc();
                for (MutableComponent extraLine : extra) {
                    TextUtil.addTooltipLineReordering(tooltip, extraLine);
                }
                this.m_96617_(transform, tooltip, mouseX, mouseY);
            }
        }
    }

    private void renderIngredients(PoseStack transform) {
        LogicWorkbenchBlockEntity.AvailableIngredients stored = this.container.getAvailableIngredients();
        transform.m_85836_();
        transform.m_85837_((double)(this.f_96543_ - 21 - 17), (double)(this.f_96544_ - 21 - 17), 0.0);
        int numTubes = this.schematic.getNumLogicTubes();
        int numWires = this.schematic.getWireLength();
        int numBoards = LogicCabinetBlockEntity.getNumBoardsFor(numTubes);
        this.renderIngredient(transform, null, numBoards, IEItemRefs.CIRCUIT_BOARD);
        transform.m_85837_(0.0, -16.0, 0.0);
        this.renderIngredient(transform, stored != null ? stored.getAvailableTubes() : null, numTubes, IEItemRefs.TUBE);
        transform.m_85837_(0.0, -16.0, 0.0);
        this.renderIngredient(transform, stored != null ? stored.getAvailableWires() : null, numWires, IEItemRefs.WIRE);
        transform.m_85849_();
    }

    private void renderIngredient(PoseStack transform, @Nullable CircuitIngredientDrawer.BigItemStack available, int required, ItemLike defaultItem) {
        TextComponent info;
        if (available != null) {
            info = new TextComponent(Math.min(available.count(), required) + " / " + required);
            if (available.count() < required) {
                info.m_130940_(ChatFormatting.RED);
            }
        } else {
            info = new TextComponent(Integer.toString(required));
        }
        info.m_130946_(" x ");
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92852_((FormattedText)info);
        float f = -width;
        Objects.requireNonNull(font);
        font.m_92889_(transform, (Component)info, f, (float)(16 - 9) / 2.0f, -1);
        ItemStack renderType = available == null || available.type().m_41619_() ? defaultItem.m_5456_().m_7968_() : available.type();
        ManualUtils.renderItemStack((PoseStack)transform, (ItemStack)renderType, (int)0, (int)0, (boolean)false);
    }

    private List<SymbolPin> getHoveredPins(PlacedSymbol hovered, Vec2d schematicMouse) {
        ArrayList<SymbolPin> result = new ArrayList<SymbolPin>();
        for (SymbolPin pin : hovered.symbol().getPins()) {
            if (!new ConnectedPin(hovered, pin).getShape().containsClosed(schematicMouse)) continue;
            result.add(pin);
        }
        return result;
    }

    private void drawErrors(PoseStack transform) {
        for (ConnectedPin pin : this.errors) {
            Vec2i pos = pin.getPosition();
            LogicDesignScreen.m_93172_((PoseStack)transform, (int)(pos.x() - 1), (int)(pos.y() - 1), (int)(pos.x() + 2), (int)(pos.y() + 2), (int)-65536);
        }
    }

    private void drawBoundary(PoseStack transform) {
        int color = -8739;
        float offset = 2.0f / this.currentScale;
        ScreenUtils.fill(transform, -512.0f - offset, -512.0f - offset, 512.0f + offset, -512.0, -8739);
        ScreenUtils.fill(transform, -512.0f - offset, -512.0f - offset, -512.0, 512.0f + offset, -8739);
        ScreenUtils.fill(transform, 512.0, -512.0f - offset, 512.0f + offset, 512.0f + offset, -8739);
        ScreenUtils.fill(transform, -512.0f - offset, 512.0, 512.0f + offset, 512.0f + offset, -8739);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        this.mouseXDown = mouseX;
        this.mouseYDown = mouseY;
        this.clickWasConsumed = false;
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (super.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.clickWasConsumed) {
            return false;
        }
        this.clickWasConsumed = true;
        Vec2d mousePos = this.getMousePosition((int)this.mouseXDown, (int)this.mouseYDown);
        PlacedSymbol placed = this.getPlacingSymbol(mousePos);
        if (placed != null) {
            if (this.schematic.makeChecker((Level)this.f_96541_.f_91073_).canAdd(placed)) {
                this.runAndSendToServer(new AddSymbol(placed));
                if (this.resetAfterPlacingSymbol) {
                    this.placingSymbol = null;
                }
            }
        } else {
            WireSegment placedWire = this.getPlacingSegment(mousePos);
            if (placedWire != null) {
                if (this.schematic.makeChecker((Level)this.f_96541_.f_91073_).canAdd(placedWire)) {
                    this.runAndSendToServer(new AddWire(placedWire));
                    this.currentWireStart = placedWire.end().equals(this.currentWireStart) ? placedWire.start() : placedWire.end();
                }
            } else {
                PlacedSymbol clicked = this.schematic.getSymbolAt(mousePos, (Level)this.f_96541_.f_91073_);
                if (clicked != null) {
                    this.handleSymbolClick(clicked, clicked.symbol(), mousePos, button);
                } else if (!this.container.readOnly) {
                    this.currentWireStart = mousePos.floor();
                }
            }
        }
        return true;
    }

    private <State> void handleSymbolClick(PlacedSymbol clicked, SymbolInstance<State> instance, Vec2d mousePos, int button) {
        if (!this.getHoveredPins(clicked, mousePos).isEmpty() && !this.container.readOnly) {
            this.currentWireStart = mousePos.floor();
            return;
        }
        if (button == 0) {
            if (this.runAndSendToServer(new Delete(mousePos))) {
                this.placingSymbol = new PlacingSymbol(clicked.symbol(), clicked.position().subtract(mousePos).add(0.5, 0.5));
                this.resetAfterPlacingSymbol = true;
            }
        } else if (!this.container.readOnly || ((SchematicSymbol)instance.getType()).canConfigureOnReadOnly()) {
            ClientSymbols.createInstanceWithUI((SchematicSymbol)instance.getType(), newInst -> this.runAndSendToServer(new ModifySymbol(new PlacedSymbol(clicked.position(), (SymbolInstance<?>)newInst))), instance.getCurrentState());
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (!(this.clickWasConsumed || Math.abs(mouseX - this.mouseXDown) > 1.0 || Math.abs(mouseY - this.mouseYDown) > 1.0)) {
            return false;
        }
        this.centerX -= dragX / (double)this.currentScale;
        this.centerY -= dragY / (double)this.currentScale;
        this.clampView();
        this.clickWasConsumed = true;
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!super.m_6050_(mouseX, mouseY, delta)) {
            float zoomScale = 1.1f;
            if (delta > 0.0) {
                this.setScale(this.currentScale * 1.1f);
            } else {
                this.setScale(this.currentScale / 1.1f);
            }
            this.clampView();
        }
        return true;
    }

    private void setScale(float newScale) {
        this.currentScale = Mth.m_14036_((float)newScale, (float)this.minScale, (float)10.0f);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.container.readOnly) {
            Vec2d mousePos;
            if (keyCode == 256) {
                if (this.currentWireStart != null || this.placingSymbol != null) {
                    this.currentWireStart = null;
                    this.placingSymbol = null;
                    return true;
                }
            } else if (keyCode == 261 && this.schematic.removeOneContaining(mousePos = this.getMousePosition(ScreenUtils.getMousePosition()), (Level)this.f_96541_.f_91073_)) {
                this.sendToServer(new Delete(mousePos));
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void renderCustomBackground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderCustomBackground(matrixStack, mouseX, mouseY, partialTicks);
        LogicDesignScreen.m_93172_((PoseStack)matrixStack, (int)20, (int)20, (int)(this.f_96543_ - 20), (int)(this.f_96544_ - 20), (int)-1);
        LogicDesignScreen.m_93172_((PoseStack)matrixStack, (int)21, (int)21, (int)(this.f_96543_ - 21), (int)(this.f_96544_ - 21), (int)-13409620);
    }

    private Vec2d getMousePosition(Vec2d screenPos) {
        return this.getMousePosition(screenPos.x(), screenPos.y());
    }

    private Vec2d getMousePosition(double mouseX, double mouseY) {
        return new Vec2d((mouseX - (double)this.f_96543_ / 2.0) / (double)this.currentScale + this.centerX, (mouseY - (double)this.f_96544_ / 2.0) / (double)this.currentScale + this.centerY);
    }

    @Nullable
    private PlacedSymbol getPlacingSymbol(Vec2d pos) {
        if (this.placingSymbol != null) {
            return new PlacedSymbol(pos.add(this.placingSymbol.offsetToMouse()).floor(), this.placingSymbol.symbol());
        }
        return null;
    }

    @Nullable
    private WireSegment getPlacingSegment(Vec2d pos) {
        if (this.currentWireStart != null) {
            double sizeY;
            double sizeX = Math.abs(pos.x() - (double)this.currentWireStart.x() - 0.5);
            if (sizeX > (sizeY = Math.abs(pos.y() - (double)this.currentWireStart.y() - 0.5))) {
                return new WireSegment(new Vec2i(this.getWireStart(this.currentWireStart.x(), pos.x()), this.currentWireStart.y()), this.getWireLength(this.currentWireStart.x(), pos.x()), WireSegment.WireAxis.X);
            }
            return new WireSegment(new Vec2i(this.currentWireStart.x(), this.getWireStart(this.currentWireStart.y(), pos.y())), this.getWireLength(this.currentWireStart.y(), pos.y()), WireSegment.WireAxis.Y);
        }
        return null;
    }

    private int getWireStart(int fixed, double mouse) {
        return mouse < (double)fixed ? Mth.m_14107_((double)mouse) : fixed;
    }

    private int getWireLength(int fixed, double mouse) {
        return mouse < (double)fixed ? Mth.m_14165_((double)((double)fixed - mouse)) : Mth.m_14107_((double)(mouse - (double)fixed));
    }

    public void setSchematic(Schematic schematic) {
        this.schematic = schematic;
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        RectangleI totalArea = null;
        for (PlacedSymbol symbol : schematic.getSymbols()) {
            totalArea = symbol.getShape((Level)level).union(totalArea);
        }
        for (SchematicNet net : schematic.getNets()) {
            for (WireSegment wire : net.getAllSegments()) {
                totalArea = wire.getShape().union(totalArea);
            }
        }
        if (totalArea == null) {
            totalArea = new RectangleI(-1, -1, 1, 1);
        }
        Vec2d center = totalArea.center();
        this.centerX = center.x();
        this.centerY = center.y();
        float scaleX = (float)(this.f_96543_ - 63) / (float)totalArea.getWidth();
        float scaleY = (float)(this.f_96544_ - 63) / (float)totalArea.getHeight();
        this.setScale(Math.min(Math.min(scaleX, scaleY), 3.0f));
        this.clampView();
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    private boolean runAndSendToServer(LogicSubPacket data) {
        if (!data.canApplyOnReadOnly() && this.container.readOnly) {
            return false;
        }
        if (this.process(data)) {
            this.sendToServer(data);
            return true;
        }
        return false;
    }

    public boolean process(LogicSubPacket packet) {
        if (packet.process(this.getSchematic(), this::setSchematic, (Level)Minecraft.m_91087_().f_91073_)) {
            this.updateErrors();
            return true;
        }
        return false;
    }

    private void sendToServer(LogicSubPacket data) {
        ControlEngineering.NETWORK.sendToServer((Object)new LogicPacket(data));
        this.updateErrors();
    }

    @Nonnull
    public LogicDesignMenu getMenu() {
        return this.container;
    }

    public void updateErrors() {
        this.errors = this.errorsShown ? SchematicCircuitConverter.getFloatingInputs(this.schematic) : ImmutableList.of();
    }

    private void clampView() {
        double halfScreenWidth = LogicDesignScreen.getShownSizeForScale(this.f_96543_, this.currentScale) / 2.0f;
        double halfScreenHeight = LogicDesignScreen.getShownSizeForScale(this.f_96544_, this.currentScale) / 2.0f;
        this.centerX = Mth.m_14008_((double)this.centerX, (double)(-512.0 + halfScreenWidth), (double)(512.0 - halfScreenWidth));
        this.centerY = Mth.m_14008_((double)this.centerY, (double)(-512.0 + halfScreenHeight), (double)(512.0 - halfScreenHeight));
    }

    private static float getShownSizeForScale(float dimensionSize, float scale) {
        return (dimensionSize - 42.0f - 5.0f) / scale;
    }

    private static float getScaleForShownSize(float size, float shownSize) {
        return (size - 42.0f - 5.0f) / shownSize;
    }

    private record PlacingSymbol(SymbolInstance<?> symbol, Vec2d offsetToMouse) {
    }
}

