/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.misc;

import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.gui.misc.BusSignalSelector;
import malte0811.controlengineering.gui.misc.DataProviderWidget;
import malte0811.controlengineering.gui.widget.ColorSelector;

public class ColorAndSignalWidget
extends DataProviderWidget<ColorAndSignal> {
    public static final int WIDTH = 128 + BusSignalSelector.WIDTH;
    public static final int HEIGHT = Math.max(60, 84);
    private final ColorSelector color;
    private final BusSignalSelector signal;

    public ColorAndSignalWidget(@Nullable ColorAndSignal initialState, int x, int y) {
        super(x, y, WIDTH, HEIGHT);
        this.color = this.addWidget(new ColorSelector(initialState != null ? initialState.color() : 0, x, y));
        this.signal = this.addWidget(new BusSignalSelector(initialState != null ? initialState.signal() : null, x + 128, y));
    }

    @Override
    @Nullable
    public ColorAndSignal getData() {
        Integer color = this.color.getData();
        BusSignalRef signal = this.signal.getData();
        if (color != null && signal != null) {
            return new ColorAndSignal(color, signal);
        }
        return null;
    }
}

