/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Function3;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusSignalRef;
import malte0811.controlengineering.controlpanels.components.config.ColorAndSignal;
import malte0811.controlengineering.controlpanels.components.config.ColorAndText;
import malte0811.controlengineering.gui.StackedScreen;
import malte0811.controlengineering.gui.misc.BusSignalSelector;
import malte0811.controlengineering.gui.misc.ColorAndSignalWidget;
import malte0811.controlengineering.gui.misc.ColorAndTextWidget;
import malte0811.controlengineering.gui.misc.IDataProviderWidget;
import malte0811.controlengineering.gui.misc.TextProviderWidget;
import malte0811.controlengineering.gui.widget.BasicSlider;
import malte0811.controlengineering.gui.widget.ColorSelector;
import malte0811.controlengineering.gui.widget.FractionSelector;
import malte0811.controlengineering.logic.cells.impl.VoltageDivider;
import malte0811.controlengineering.util.math.Fraction;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class DataProviderScreen<T>
extends StackedScreen {
    public static final String DONE_KEY = "controlengineering.gui.done";
    private static final Map<MyCodec<?>, IDataProviderWidget.Factory<?, ?>> KNOWN_FACTORIES = new HashMap();
    private final IDataProviderWidget.Factory<T, ?> factory;
    @Nullable
    private final T initial;
    private final Consumer<T> out;
    private IDataProviderWidget<T> provider;

    private static <T, W extends AbstractWidget> void registerFactoryFunc3(MyCodec<T> type, final Function3<T, Integer, Integer, W> factory) {
        DataProviderScreen.registerFactory(type, new IDataProviderWidget.Factory<T, W>(){

            @Override
            public W create(@Nullable T currentValue, int x, int y) {
                return (AbstractWidget)factory.apply(currentValue, (Object)x, (Object)y);
            }
        });
    }

    private static <T> void registerFactory(MyCodec<T> type, IDataProviderWidget.Factory<T, ?> factory) {
        KNOWN_FACTORIES.put(type, factory);
    }

    @Nullable
    public static <T> DataProviderScreen<T> makeFor(Component title, @Nonnull T initial, MyCodec<T> type, Consumer<T> out) {
        IDataProviderWidget.Factory<?, ?> factory = KNOWN_FACTORIES.get(type);
        if (factory != null) {
            return new DataProviderScreen(title, factory, initial, out);
        }
        return null;
    }

    public DataProviderScreen(Component titleIn, IDataProviderWidget.Factory<T, ?> factory, @Nullable T initial, Consumer<T> out) {
        super(titleIn);
        this.factory = factory;
        this.initial = initial;
        this.out = out;
    }

    protected void m_7856_() {
        super.m_7856_();
        Object providerTemp = this.factory.create(this.initial, 0, 0);
        int xMin = (this.f_96543_ - providerTemp.m_5711_()) / 2;
        int yMin = (this.f_96544_ - providerTemp.m_93694_()) / 2;
        Object provider = this.factory.create(this.initial, xMin, yMin);
        this.m_142416_((GuiEventListener)provider);
        this.m_142416_((GuiEventListener)new Button(xMin, yMin + provider.m_93694_() + 10, provider.m_5711_(), 20, (Component)new TranslatableComponent(DONE_KEY), $ -> this.m_7379_()));
        this.provider = (IDataProviderWidget)provider;
    }

    public void m_7861_() {
        super.m_7861_();
        T result = this.provider.getData();
        if (result != null) {
            this.out.accept(result);
        }
    }

    @Override
    protected void renderForeground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    static {
        DataProviderScreen.registerFactoryFunc3(BusSignalRef.CODEC, BusSignalSelector::new);
        DataProviderScreen.registerFactoryFunc3(ColorAndSignal.CODEC, ColorAndSignalWidget::new);
        DataProviderScreen.registerFactoryFunc3(ColorAndText.CODEC, ColorAndTextWidget::new);
        DataProviderScreen.registerFactoryFunc3(MyCodecs.HEX_COLOR, ColorSelector::new);
        DataProviderScreen.registerFactoryFunc3(MyCodecs.STRING, TextProviderWidget::arbitrary);
        DataProviderScreen.registerFactory(VoltageDivider.RESISTANCE_CODEC, BasicSlider.withRange(0, 100, "controlengineering.gui.lower_resistance"));
        DataProviderScreen.registerFactory(Fraction.CODEC, FractionSelector.with(255, "controlengineering.gui.amp.amplify", "controlengineering.gui.amp.attenuate"));
    }
}

