/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.panel;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.client.render.target.MixedModel;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.renders.ComponentRenderers;
import malte0811.controlengineering.gui.widget.NestedWidget;
import malte0811.controlengineering.gui.widget.PageSelector;
import malte0811.controlengineering.util.math.TransformUtil;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ComponentSelector
extends NestedWidget {
    private static final int ROW_MIN_HEIGHT = 40;
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<PanelComponentType<?, ?>> available;
    private final int numCols = 2;
    private final int numRows;
    private final int actualRowHeight;
    private final int colWidth;
    private final Consumer<PanelComponentType<?, ?>> select;
    private final PageSelector pageSelector;

    public ComponentSelector(int x, int y, int width, int height, Consumer<PanelComponentType<?, ?>> select) {
        super(x, y, width, height);
        this.select = select;
        this.available = new ArrayList(PanelComponents.REGISTRY.getValues());
        int displayHeight = height - 20;
        this.numRows = Math.max(displayHeight / 40, 1);
        this.actualRowHeight = displayHeight / this.numRows;
        this.colWidth = width / 2;
        this.pageSelector = new PageSelector(x, y + displayHeight, width, Mth.m_14165_((double)((double)this.available.size() / (double)(this.numRows * 2))), 0);
        this.addWidget(this.pageSelector);
    }

    @Override
    public void m_6303_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
        int selectedRow = (mouseY - this.f_93621_) / this.actualRowHeight;
        int selectedCol = (mouseX - this.f_93620_) / this.colWidth;
        for (int col = 0; col < 2; ++col) {
            for (int row = 0; row < this.numRows; ++row) {
                this.renderAvailableType(matrixStack, this.getTypeIn(row, col), this.f_93620_ + col * this.colWidth, this.f_93621_ + row * this.actualRowHeight, col == selectedCol && row == selectedRow);
            }
        }
    }

    private void renderAvailableType(@Nonnull PoseStack transform, @Nullable PanelComponentType<?, ?> type, int x, int y, boolean highlight) {
        transform.m_85836_();
        transform.m_85837_((double)x, (double)y, 0.0);
        if (highlight && type != null) {
            ComponentSelector.m_93172_((PoseStack)transform, (int)0, (int)0, (int)this.colWidth, (int)this.actualRowHeight, (int)-5592321);
        } else {
            ComponentSelector.m_93172_((PoseStack)transform, (int)0, (int)0, (int)this.colWidth, (int)this.actualRowHeight, (int)-5592406);
        }
        if (type != null) {
            transform.m_85837_(0.0, 1.0, 0.0);
            String name = I18n.m_118938_((String)type.getTranslationKey(), (Object[])new Object[0]);
            ComponentSelector.drawCenteredShrunkString(transform, this.mc.f_91062_, name, 0, this.colWidth, 0, 0);
            Objects.requireNonNull(this.mc.f_91062_);
            transform.m_85837_(0.0, 9.0, 0.0);
            double d = this.colWidth;
            double d2 = this.actualRowHeight;
            Objects.requireNonNull(this.mc.f_91062_);
            ComponentSelector.renderComponentInGui(transform, type, d, d2 - 9.0 * 1.5);
        }
        transform.m_85849_();
    }

    public static void renderComponentInGui(@Nonnull PoseStack transform, @Nonnull PanelComponentType<?, ?> type, double width, double height) {
        transform.m_85836_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        PanelComponentInstance component = (PanelComponentInstance)type.newInstance();
        Vec2d componentSize = component.getSize((Level)level);
        Vec2d areaSize = new Vec2d(width, height);
        float extraScale = (float)Math.min(Math.min(areaSize.x() / componentSize.x(), areaSize.y() / componentSize.y()), 16.0);
        transform.m_85837_(width / 2.0, height / 2.0, 0.0);
        transform.m_85841_(extraScale, extraScale, 0.01f);
        transform.m_85837_(-component.getSize((Level)level).x() / 2.0, -component.getSize((Level)level).y() / 2.0, 0.0);
        transform.m_85845_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
        TransformUtil.shear(transform, 0.1f, 0.1f);
        transform.m_85841_(1.0f, -1.0f, 1.0f);
        MixedModel model = new MixedModel(new RenderType[0]);
        ComponentRenderers.render(model, component, transform);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        model.renderTo((MultiBufferSource)buffers, new PoseStack(), LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        buffers.m_109911_();
        transform.m_85849_();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        PanelComponentType<?, ?> type;
        if (mouseX < (double)this.f_93620_ || mouseY < (double)this.f_93621_ || mouseX > (double)(this.f_93620_ + this.f_93618_) || mouseY > (double)(this.f_93621_ + this.f_93619_)) {
            return false;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int row = (int)((mouseY - (double)this.f_93621_) / (double)this.actualRowHeight);
        int col = (int)((mouseX - (double)this.f_93620_) / (double)this.colWidth);
        if (row >= 0 && row < this.numRows && col >= 0 && col < 2 && (type = this.getTypeIn(row, col)) != null) {
            this.select.accept(type);
            return true;
        }
        return false;
    }

    @Nullable
    private PanelComponentType<?, ?> getTypeIn(int row, int col) {
        int index = this.pageSelector.getCurrentPage() * this.numRows * 2 + row * 2 + col;
        if (index < 0 || index >= this.available.size()) {
            return null;
        }
        return this.available.get(index);
    }

    @Override
    public void m_142291_(@Nonnull NarrationElementOutput pNarrationElementOutput) {
    }

    private static void drawCenteredShrunkString(PoseStack transform, Font font, String text, int xMin, int xMax, int y, int color) {
        int textWidth = font.m_92895_(text);
        int areaWidth = xMax - xMin;
        float scale = Math.min(1.0f, (float)areaWidth / (float)textWidth);
        double areaCenter = (double)xMin + (double)areaWidth / 2.0;
        transform.m_85836_();
        transform.m_85837_(areaCenter - (double)(scale * (float)textWidth) / 2.0, (double)y, 0.0);
        transform.m_85841_(scale, scale, 1.0f);
        font.m_92883_(transform, text, 0.0f, 0.0f, color);
        transform.m_85849_();
    }
}

