/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.gui.panel;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.gui.StackedScreen;
import malte0811.controlengineering.gui.panel.ComponentSelector;
import malte0811.controlengineering.gui.panel.PanelDesignMenu;
import malte0811.controlengineering.gui.panel.PanelLayout;
import malte0811.controlengineering.util.ScreenUtils;
import malte0811.controlengineering.util.math.Vec2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class PanelDesignScreen
extends StackedScreen
implements MenuAccess<PanelDesignMenu> {
    public static final String REQUIRED_VS_AVAILABLE_TAPE = "controlengineering.gui.reqVsAvTape";
    private static final int BORDER = 20;
    @Nonnull
    private final PanelDesignMenu container;
    private int panelLayoutXMin;
    private int panelLayoutYMax;

    public PanelDesignScreen(@Nonnull PanelDesignMenu container, Component title) {
        super(title);
        this.container = container;
    }

    protected void m_7856_() {
        super.m_7856_();
        int usedHeight = this.f_96544_ - 40;
        int availableWidth = this.f_96543_ - 40;
        int selectorWidth = Mth.m_14045_((int)(availableWidth - usedHeight), (int)100, (int)(usedHeight / 2));
        int panelSize = Mth.m_14045_((int)usedHeight, (int)150, (int)(availableWidth - selectorWidth));
        int usedWidth = selectorWidth + panelSize;
        int offset = (this.f_96543_ - usedWidth) / 2;
        this.panelLayoutXMin = selectorWidth + offset;
        this.panelLayoutYMax = 20 + panelSize;
        PanelLayout panelLayout = new PanelLayout(this.panelLayoutXMin, 20, panelSize, this.container.getComponents());
        this.m_142416_((GuiEventListener)new ComponentSelector(offset, 20, selectorWidth, panelSize, panelLayout::setPlacingComponent));
        this.m_142416_((GuiEventListener)panelLayout);
    }

    @Override
    protected void renderForeground(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int available;
        int required = this.container.getRequiredTapeLength();
        int color = required <= (available = this.container.getAvailableTapeLength()) ? -1 : -65536;
        Minecraft.m_91087_().f_91062_.m_92889_(matrixStack, (Component)new TranslatableComponent(REQUIRED_VS_AVAILABLE_TAPE, new Object[]{required, available}), (float)this.panelLayoutXMin, (float)(this.panelLayoutYMax + 5), color);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Vec2d mouse = ScreenUtils.getMousePosition();
        for (GuiEventListener button : this.m_6702_()) {
            if (!button.m_5953_(mouse.x(), mouse.y())) continue;
            if (!button.m_7933_(keyCode, scanCode, modifiers)) break;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public List<PlacedComponent> getComponents() {
        return this.container.getComponents();
    }

    @Nonnull
    public PanelDesignMenu getMenu() {
        return this.container;
    }
}

